/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.gui;

import gg.essential.universal.UGraphics;
import gg.essential.universal.UMinecraft;
import gg.mantle.mod.MantleConstants;
import gg.mantle.mod.client.gui.Glyph;
import gg.mantle.mod.client.gui.MantlePalette;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 52\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R$\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020#8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b,\u0010\u001aR\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R$\u00103\u001a\u00020#2\u0006\u0010$\u001a\u00020#8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b3\u0010&\u001a\u0004\b4\u0010(\u00a8\u00066"}, d2={"Lgg/mantle/mod/client/gui/GlyphMap;", "", "Ljava/awt/Font;", "font", "", "start", "end", "<init>", "(Ljava/awt/Font;CC)V", "Ljava/awt/image/BufferedImage;", "image", "", "createDebugImage", "(Ljava/awt/image/BufferedImage;)V", "char", "", "exists", "(C)Z", "free", "()V", "generate", "Lgg/mantle/mod/client/gui/Glyph;", "getGlyph", "(C)Lgg/mantle/mod/client/gui/Glyph;", "C", "getEnd", "()C", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "generated", "Z", "", "glyphs", "Ljava/util/Map;", "", "<set-?>", "height", "I", "getHeight", "()I", "Ljava/awt/font/FontRenderContext;", "initialFontRenderCtx", "Ljava/awt/font/FontRenderContext;", "getStart", "Lnet/minecraft/class_2960;", "texture", "Lnet/minecraft/class_2960;", "Ljava/awt/geom/AffineTransform;", "transform", "Ljava/awt/geom/AffineTransform;", "width", "getWidth", "Companion", "Mantle"})
@SourceDebugExtension(value={"SMAP\nCustomFontProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFontProvider.kt\ngg/mantle/mod/client/gui/GlyphMap\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,371:1\n215#2,2:372\n*S KotlinDebug\n*F\n+ 1 CustomFontProvider.kt\ngg/mantle/mod/client/gui/GlyphMap\n*L\n352#1:372,2\n*E\n"})
public final class GlyphMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Font font;
    private final char start;
    private final char end;
    @NotNull
    private final Map<Character, Glyph> glyphs;
    private boolean generated;
    @NotNull
    private final AffineTransform transform;
    @NotNull
    private final FontRenderContext initialFontRenderCtx;
    @NotNull
    private final class_2960 texture;
    private int width;
    private int height;
    private static final boolean debugMode = MantleConstants.getDebugMode() || Boolean.parseBoolean(System.getProperty("mantle.debug.fonts", "false"));
    private static final int GLYPH_PADDING = 5;
    @NotNull
    private static final char[] nameChars;

    /*
     * WARNING - void declaration
     */
    public GlyphMap(@NotNull Font font, char start, char end) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.font = font;
        this.start = start;
        this.end = end;
        this.glyphs = new LinkedHashMap();
        this.transform = new AffineTransform();
        this.initialFontRenderCtx = new FontRenderContext(this.transform, true, false);
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        String string = "mantlegg";
        GlyphMap glyphMap = this;
        boolean bl = false;
        int n = 16;
        int n2 = 0;
        while (n2 < n) {
            void $this$texture_u24lambda_u241;
            int it = n2++;
            boolean bl2 = false;
            $this$texture_u24lambda_u241.append(ArraysKt.random((char[])nameChars, (Random)((Random)Random.Default)));
        }
        Unit unit = Unit.INSTANCE;
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = "fonts/" + string2;
        String string4 = string;
        glyphMap.texture = new class_2960(string4, string3);
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    public final char getStart() {
        return this.start;
    }

    public final char getEnd() {
        return this.end;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Glyph getGlyph(char c) {
        Glyph glyph = this.glyphs.get(Character.valueOf(c));
        if (glyph == null) {
            GlyphMap $this$getGlyph_u24lambda_u242 = this;
            boolean bl = false;
            if (!$this$getGlyph_u24lambda_u242.generated) {
                $this$getGlyph_u24lambda_u242.generate();
            }
            if ((glyph = $this$getGlyph_u24lambda_u242.glyphs.get(Character.valueOf(c))) == null) {
                throw new IllegalStateException("Glyph '" + c + "' not found");
            }
        }
        return glyph;
    }

    public final boolean exists(char c) {
        return this.glyphs.containsKey(Character.valueOf(c));
    }

    public final void free() {
        UMinecraft.getMinecraft().method_1531().method_4615(this.texture);
        this.glyphs.clear();
        this.width = -1;
        this.height = -1;
        this.generated = false;
    }

    private final void generate() {
        if (this.generated) {
            return;
        }
        this.glyphs.clear();
        Map generatedGlyphs = new LinkedHashMap();
        int range = this.end - this.start - 1;
        int charsVert = (int)((double)((int)Math.ceil(Math.sqrt(range))) * 1.5);
        int i = 0;
        int x = 0;
        int y = 0;
        int largestX = 0;
        int largestY = 0;
        int currentRowLargestY = 0;
        int charNX = 0;
        while (i <= range) {
            char current = (char)(this.start + i);
            Rectangle2D bounds = this.font.getStringBounds(String.valueOf(current), this.initialFontRenderCtx);
            int width = (int)Math.ceil(bounds.getWidth());
            int height = (int)Math.ceil(bounds.getHeight());
            ++i;
            largestX = Math.max(largestX, x + width);
            largestY = Math.max(largestY, y + height);
            if (charNX >= charsVert) {
                x = 0;
                y += currentRowLargestY + 5;
                charNX = 0;
                currentRowLargestY = 0;
            }
            currentRowLargestY = Math.max(currentRowLargestY, height);
            Character c = Character.valueOf(current);
            generatedGlyphs.put(c, new Glyph(x, y, width, height, this.texture, this));
            x += width + 5;
            ++charNX;
        }
        BufferedImage image = new BufferedImage(Math.max(largestX + 5, 1), Math.max(largestY + 5, 1), 2);
        this.width = image.getWidth();
        this.height = image.getHeight();
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setFont(this.font);
        graphics.setColor(MantlePalette.getTRANSPARENT());
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        graphics.setColor(Color.WHITE);
        Map $this$forEach$iv = generatedGlyphs;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            char c = ((Character)entry.getKey()).charValue();
            Glyph glyph = (Glyph)entry.getValue();
            FontMetrics metrics = graphics.getFontMetrics();
            graphics.drawString(String.valueOf(c), glyph.getU(), glyph.getV() + (float)metrics.getAscent());
            Character c2 = Character.valueOf(c);
            this.glyphs.put(c2, glyph);
        }
        if (debugMode) {
            this.createDebugImage(image);
        }
        UMinecraft.getMinecraft().method_1531().method_4616(this.texture, (class_1044)UGraphics.getTexture((BufferedImage)image));
        this.generated = true;
    }

    private final void createDebugImage(BufferedImage image) {
        String filename = "glyphs " + this.start + "_" + this.end + " (" + this.font.getFontName() + ").png";
        File file = FilesKt.resolve((File)new File(MantleConstants.getModDirectory(), "Fonts"), (String)filename);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Failed to create parent directories for file " + filename);
        }
        ImageIO.write((RenderedImage)image, "png", file);
    }

    static {
        char[] cArray = "0123456789abcdefghijklmnopqrstuvwxyz_-".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        nameChars = cArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgg/mantle/mod/client/gui/GlyphMap$Companion;", "", "<init>", "()V", "", "GLYPH_PADDING", "I", "", "debugMode", "Z", "", "nameChars", "[C", "Mantle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

