/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.gui;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.ConstraintType;
import gg.essential.elementa.constraints.resolution.ConstraintVisitor;
import gg.essential.elementa.font.FontProvider;
import gg.essential.universal.ChatColor;
import gg.essential.universal.UGraphics;
import gg.essential.universal.UMatrixStack;
import gg.essential.universal.UResolution;
import gg.mantle.mod.client.gui.CustomFontProvider;
import gg.mantle.mod.client.gui.Glyph;
import gg.mantle.mod.client.gui.GlyphMap;
import gg.mantle.mod.client.gui.MantlePaletteKt;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 R2\u00020\u0001:\u0001RB#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJY\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u001f\u0010!\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010#\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b#\u0010\"J!\u0010%\u001a\u00020$2\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020\n\u00a2\u0006\u0004\b,\u0010\fJ\u001f\u00100\u001a\u00020\n2\u0006\u0010.\u001a\u00020-2\u0006\u0010\u0005\u001a\u00020/H\u0016\u00a2\u0006\u0004\b0\u00101R\"\u00102\u001a\u00020\u00018\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u00109\u001a\u0004\u0018\u0001088\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u0018\u0010?\u001a\u0004\u0018\u00010$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u001d\u0010C\u001a\b\u0012\u0004\u0012\u00020B0A8\u0006\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010FR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010GR\u0016\u0010H\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\"\u0010J\u001a\u00020\u00168\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0016\u0010P\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010IR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010IR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010Q\u00a8\u0006S"}, d2={"Lgg/mantle/mod/client/gui/CustomFontProvider;", "Lgg/essential/elementa/font/FontProvider;", "", "path", "", "type", "", "size", "<init>", "(Ljava/lang/String;IF)V", "", "checkSize", "()V", "Lgg/essential/universal/UMatrixStack;", "stack", "text", "Ljava/awt/Color;", "color", "x", "y", "originalPointSize", "scale", "", "shadow", "shadowColor", "drawString", "(Lgg/essential/universal/UMatrixStack;Ljava/lang/String;Ljava/awt/Color;FFFFZLjava/awt/Color;)V", "getBaseLineHeight", "()F", "getBelowLineHeight", "getShadowHeight", "string", "pointSize", "getStringHeight", "(Ljava/lang/String;F)F", "getStringWidth", "Ljava/awt/Font;", "loadFont", "(Ljava/lang/String;I)Ljava/awt/Font;", "", "char", "Lgg/mantle/mod/client/gui/Glyph;", "locateGlyph", "(C)Lgg/mantle/mod/client/gui/Glyph;", "preInitialize", "Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;", "visitor", "Lgg/essential/elementa/constraints/ConstraintType;", "visitImpl", "(Lgg/essential/elementa/constraints/resolution/ConstraintVisitor;Lgg/essential/elementa/constraints/ConstraintType;)V", "cachedValue", "Lgg/essential/elementa/font/FontProvider;", "getCachedValue", "()Lgg/essential/elementa/font/FontProvider;", "setCachedValue", "(Lgg/essential/elementa/font/FontProvider;)V", "Lgg/essential/elementa/UIComponent;", "constrainTo", "Lgg/essential/elementa/UIComponent;", "getConstrainTo", "()Lgg/essential/elementa/UIComponent;", "setConstrainTo", "(Lgg/essential/elementa/UIComponent;)V", "font", "Ljava/awt/Font;", "", "Lgg/mantle/mod/client/gui/GlyphMap;", "glyphMaps", "Ljava/util/Set;", "getGlyphMaps", "()Ljava/util/Set;", "Ljava/lang/String;", "prevScaleFactor", "F", "recalculate", "Z", "getRecalculate", "()Z", "setRecalculate", "(Z)V", "scaleFactor", "I", "Companion", "Mantle"})
@SourceDebugExtension(value={"SMAP\nCustomFontProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomFontProvider.kt\ngg/mantle/mod/client/gui/CustomFontProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,371:1\n1855#2,2:372\n288#2,2:376\n1282#3,2:374\n*S KotlinDebug\n*F\n+ 1 CustomFontProvider.kt\ngg/mantle/mod/client/gui/CustomFontProvider\n*L\n56#1:372,2\n226#1:376,2\n157#1:374,2\n*E\n"})
public final class CustomFontProvider
implements FontProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    private final int type;
    private final float size;
    @NotNull
    private FontProvider cachedValue;
    @Nullable
    private UIComponent constrainTo;
    private boolean recalculate;
    private float scaleFactor;
    private float prevScaleFactor;
    @Nullable
    private Font font;
    @NotNull
    private final Set<GlyphMap> glyphMaps;
    public static final float FONT_SIZE = 9.0f;
    @NotNull
    private static final Lazy<List<Character>> formattingCodes$delegate = LazyKt.lazy((Function0)Companion.formattingCodes.2.INSTANCE);

    public CustomFontProvider(@NotNull String path, int type, float size) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.type = type;
        this.size = size;
        this.cachedValue = this;
        this.scaleFactor = 1.0f;
        this.prevScaleFactor = 1.0f;
        this.glyphMaps = new CopyOnWriteArraySet();
    }

    public /* synthetic */ CustomFontProvider(String string, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            f = 9.0f;
        }
        this(string, n, f);
    }

    @NotNull
    public FontProvider getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(@NotNull FontProvider fontProvider) {
        Intrinsics.checkNotNullParameter((Object)fontProvider, (String)"<set-?>");
        this.cachedValue = fontProvider;
    }

    @Nullable
    public UIComponent getConstrainTo() {
        return this.constrainTo;
    }

    public void setConstrainTo(@Nullable UIComponent uIComponent) {
        this.constrainTo = uIComponent;
    }

    public boolean getRecalculate() {
        return this.recalculate;
    }

    public void setRecalculate(boolean bl) {
        this.recalculate = bl;
    }

    @NotNull
    public final Set<GlyphMap> getGlyphMaps() {
        return this.glyphMaps;
    }

    public final void preInitialize() {
        this.font = this.loadFont(this.path, this.type).deriveFont(this.size * this.scaleFactor);
    }

    public final void checkSize() {
        float currentScaleFactor = (float)UResolution.getScaleFactor();
        if (!(currentScaleFactor == this.scaleFactor)) {
            this.prevScaleFactor = this.scaleFactor;
            this.scaleFactor = currentScaleFactor;
            this.font = this.loadFont(this.path, this.type).deriveFont(this.size * this.scaleFactor);
            Iterable $this$forEach$iv = this.glyphMaps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GlyphMap p0 = (GlyphMap)element$iv;
                boolean bl = false;
                p0.free();
            }
            this.glyphMaps.clear();
        }
    }

    public void visitImpl(@NotNull ConstraintVisitor visitor, @NotNull ConstraintType type) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
    }

    public float getStringWidth(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        float width = 0.0f;
        boolean isFormatting = false;
        for (char c : chars) {
            if (c == '\u00a7') {
                isFormatting = true;
                continue;
            }
            if (isFormatting) {
                isFormatting = false;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            width += (float)glyph.getWidth() / this.scaleFactor;
        }
        return width;
    }

    public float getStringHeight(@NotNull String string, float pointSize) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        float height = 0.0f;
        boolean isFormatting = false;
        for (char c : chars) {
            if (c == '\u00a7') {
                isFormatting = true;
                continue;
            }
            if (isFormatting) {
                isFormatting = false;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            height = Math.max(height, (float)glyph.getHeight() / this.scaleFactor);
        }
        return height;
    }

    public void drawString(@NotNull UMatrixStack stack, @NotNull String text2, @NotNull Color color, float x, float y, float originalPointSize, float scale, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.checkSize();
        if (shadow) {
            Color color2 = shadowColor;
            if (color2 == null) {
                Color color3 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"BLACK");
                color2 = MantlePaletteKt.withAlpha(color3, color.getAlpha());
            }
            Color shadowColor2 = color2;
            this.drawString(stack, text2, shadowColor2, x + 0.5f, y + 0.5f, originalPointSize, scale, false, null);
        }
        stack.push();
        stack.translate(x, y, 1.0f);
        stack.scale(1.0f / this.scaleFactor, 1.0f / this.scaleFactor, 1.0f);
        stack.scale(scale, scale, 1.0f);
        int currentColor = color.getRGB();
        char[] cArray = text2.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        UGraphics buffer = UGraphics.getFromTessellator();
        float currentX = 0.0f;
        float currentY = 0.0f;
        float largestHeight = 0.0f;
        int i = 0;
        while (i < chars.length) {
            char current = chars[i];
            if (current == '\u00a7') {
                if (i + 1 >= chars.length) break;
                char next = chars[i + 1];
                if (CustomFontProvider.Companion.getFormattingCodes().contains(Character.valueOf(next))) {
                    Color color4;
                    Color formatting;
                    block7: {
                        Color color5;
                        ChatColor[] $this$firstOrNull$iv = ChatColor.values();
                        boolean $i$f$firstOrNull = false;
                        int n = $this$firstOrNull$iv.length;
                        for (int j = 0; j < n; ++j) {
                            ChatColor element$iv;
                            ChatColor it = element$iv = $this$firstOrNull$iv[j];
                            boolean bl = false;
                            if (!(it.getChar() == next)) continue;
                            color5 = element$iv;
                            break block7;
                        }
                        color5 = formatting = null;
                    }
                    currentColor = formatting == ChatColor.RESET ? color.getRGB() : ((color4 = formatting) != null && (color4 = color4.getColor()) != null ? color4.getRGB() : currentColor);
                    i += 2;
                    continue;
                }
            }
            if (current == '\n') {
                currentX = 0.0f;
                currentY += largestHeight;
                largestHeight = 0.0f;
                ++i;
                continue;
            }
            Glyph glyph = this.locateGlyph(current);
            largestHeight = Math.max(largestHeight, (float)glyph.getHeight());
            Color newColor = new Color(currentColor);
            float red = (float)newColor.getRed() / 255.0f;
            float green = (float)newColor.getGreen() / 255.0f;
            float blue = (float)newColor.getBlue() / 255.0f;
            float alpha = (float)newColor.getAlpha() / 255.0f;
            buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
            UGraphics.bindTexture((int)0, (class_2960)glyph.getTexture());
            float u1 = glyph.getU() / (float)glyph.getMap().getWidth();
            float v1 = glyph.getV() / (float)glyph.getMap().getHeight();
            float u2 = (glyph.getU() + (float)glyph.getWidth()) / (float)glyph.getMap().getWidth();
            float v2 = (glyph.getV() + (float)glyph.getHeight()) / (float)glyph.getMap().getHeight();
            float glyphHeight = glyph.getHeight();
            float glyphWidth = glyph.getWidth();
            buffer.pos(stack, (double)currentX, (double)(glyphHeight + currentY), 0.0).tex((double)u1, (double)v2).color(red, green, blue, alpha).endVertex();
            buffer.pos(stack, (double)(glyphWidth + currentX), (double)(glyphHeight + currentY), 0.0).tex((double)u2, (double)v2).color(red, green, blue, alpha).endVertex();
            buffer.pos(stack, (double)(glyphWidth + currentX), (double)currentY, 0.0).tex((double)u2, (double)v1).color(red, green, blue, alpha).endVertex();
            buffer.pos(stack, (double)currentX, (double)currentY, 0.0).tex((double)u1, (double)v1).color(red, green, blue, alpha).endVertex();
            UGraphics.enableBlend();
            UGraphics.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            buffer.drawDirect();
            UGraphics.disableBlend();
            currentX += (float)glyph.getWidth();
            ++i;
        }
        stack.pop();
    }

    public float getBaseLineHeight() {
        return 9.0f;
    }

    public float getShadowHeight() {
        return 0.5f;
    }

    public float getBelowLineHeight() {
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final Font loadFont(String path, int type) {
        void $this$loadFont_u24lambda_u241;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        Class<CustomFontProvider> clazz = CustomFontProvider.class;
        int n = type;
        boolean bl = false;
        if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            $this$loadFont_u24lambda_u241.append("/");
        }
        $this$loadFont_u24lambda_u241.append(path);
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Font font = Font.createFont(n, clazz.getResourceAsStream(string));
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"createFont(type, CustomF\u2026     append(path)\n    }))");
        return font;
    }

    static /* synthetic */ Font loadFont$default(CustomFontProvider customFontProvider, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return customFontProvider.loadFont(string, n);
    }

    private final Glyph locateGlyph(char c) {
        Glyph glyph;
        Glyph glyph2;
        Object v0;
        GlyphMap map;
        block3: {
            Iterable $this$firstOrNull$iv = this.glyphMaps;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                map = (GlyphMap)element$iv;
                boolean bl = false;
                if (!map.exists(c)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        GlyphMap glyphMap = v0;
        if (glyphMap != null && (glyph2 = glyphMap.getGlyph(c)) != null) {
            glyph = glyph2;
        } else {
            CustomFontProvider $this$locateGlyph_u24lambda_u243 = this;
            boolean bl = false;
            Font font = $this$locateGlyph_u24lambda_u243.font;
            Intrinsics.checkNotNull((Object)font);
            map = new GlyphMap(font, c, (char)(c + 50));
            $this$locateGlyph_u24lambda_u243.glyphMaps.add(map);
            glyph = map.getGlyph(c);
        }
        return glyph;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\f\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lgg/mantle/mod/client/gui/CustomFontProvider$Companion;", "", "<init>", "()V", "", "FONT_SIZE", "F", "", "", "formattingCodes$delegate", "Lkotlin/Lazy;", "getFormattingCodes", "()Ljava/util/List;", "formattingCodes", "Mantle"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Character> getFormattingCodes() {
            Lazy lazy = formattingCodes$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

