/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.cosmetics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.mantle.mod.MantleConstants;
import gg.mantle.mod.client.cosmetics.AnimatableTexture;
import gg.mantle.mod.client.cosmetics.BaseCosmetic;
import gg.mantle.mod.client.cosmetics.CosmeticBakery;
import gg.mantle.mod.client.cosmetics.CosmeticModelSprite;
import gg.mantle.mod.client.cosmetics.CosmeticRegistry;
import gg.mantle.mod.client.cosmetics.CosmeticsKt;
import gg.mantle.mod.client.cosmetics.LoadedCosmetic;
import gg.mantle.mod.utils.JsonKt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R \u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lgg/mantle/mod/client/cosmetics/CosmeticBakery;", "", "<init>", "()V", "Lgg/mantle/mod/client/cosmetics/LoadedCosmetic;", "cosmetic", "Lnet/minecraft/class_793;", "model", "Lnet/minecraft/class_1087;", "bake", "(Lgg/mantle/mod/client/cosmetics/LoadedCosmetic;Lnet/minecraft/class_793;)Lnet/minecraft/class_1087;", "Lgg/mantle/mod/client/cosmetics/BaseCosmetic;", "", "configuration", "create", "(Lgg/mantle/mod/client/cosmetics/BaseCosmetic;Ljava/lang/String;)Lnet/minecraft/class_793;", "Lnet/minecraft/class_1088;", "loader", "", "setup", "(Lnet/minecraft/class_1088;)V", "", "cachedDeserializedModels", "Ljava/util/Map;", "cachedModels", "", "debugMode", "Z", "Lnet/minecraft/class_1088;", "Mantle"})
public final class CosmeticBakery {
    @NotNull
    public static final CosmeticBakery INSTANCE = new CosmeticBakery();
    private static final boolean debugMode = MantleConstants.getDebugMode() || Boolean.parseBoolean(System.getProperty("mantle.debug.cosmetics.models", "false"));
    private static class_1088 loader;
    @NotNull
    private static final Map<String, class_793> cachedDeserializedModels;
    @NotNull
    private static final Map<String, class_1087> cachedModels;

    private CosmeticBakery() {
    }

    @JvmStatic
    public static final void setup(@NotNull class_1088 loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        CosmeticBakery.loader = loader;
    }

    @Nullable
    public final class_793 create(@NotNull BaseCosmetic cosmetic, @NotNull String configuration) {
        Object json;
        Intrinsics.checkNotNullParameter((Object)cosmetic, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (StringsKt.isBlank((CharSequence)cosmetic.getId())) {
            throw new IllegalStateException("Cosmetic ID cannot be blank!".toString());
        }
        if (cachedDeserializedModels.containsKey(cosmetic.getId())) {
            class_793 class_7932 = cachedDeserializedModels.get(cosmetic.getId());
            Intrinsics.checkNotNull((Object)class_7932);
            return class_7932;
        }
        if (debugMode) {
            String formatted;
            String filename = "cosmetic " + CosmeticsKt.getIdPrefix(cosmetic) + "-" + cosmetic.getId() + " (" + cosmetic.getName() + ") (RAW).json";
            File file = FilesKt.resolve((File)new File(MantleConstants.getModDirectory(), "Cosmetics"), (String)filename);
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IllegalStateException(("Failed to create parent directories for " + filename + "!").toString());
            }
            try {
                json = JsonKt.parseJson(configuration);
                formatted = gg.mantle.mod.client.utils.JsonKt.getClientGson().toJson((JsonElement)json);
                Intrinsics.checkNotNullExpressionValue((Object)formatted, (String)"formatted");
                FilesKt.writeText$default((File)file, (String)formatted, null, (int)2, null);
            }
            catch (Exception e) {
                formatted = configuration;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                byte[] byArray = formatted.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                FilesKt.writeBytes((File)file, (byte[])byArray);
            }
        }
        class_2960 identifier = CosmeticsKt.getIdentifier(cosmetic);
        try {
            json = JsonKt.parseJson(configuration);
            JsonElement jsonElement = json.getAsJsonObject().get("textures");
            Object object = jsonElement != null ? jsonElement.getAsJsonObject() : null;
            if (object == null) {
                throw new IllegalStateException("Failed to find textures in cosmetic configuration!".toString());
            }
            JsonObject textures = object;
            textures.addProperty("1", identifier.toString());
            textures.addProperty("particle", identifier.toString());
            JsonElement jsonElement2 = json.getAsJsonObject().get("elements");
            Object object2 = jsonElement2 != null ? jsonElement2.getAsJsonArray() : null;
            if (object2 == null) {
                throw new IllegalStateException("Failed to find elements in cosmetic configuration!".toString());
            }
            JsonArray elements = object2;
            for (JsonElement element : elements) {
                double halfDiff;
                double diff;
                double epsilon = 0.001;
                JsonObject elementObject = element.getAsJsonObject();
                JsonArray from = elementObject.get("from").getAsJsonArray();
                JsonArray to = elementObject.get("to").getAsJsonArray();
                JsonArray newFrom = new JsonArray();
                JsonArray newTo = new JsonArray();
                double fromX = from.get(0).getAsDouble();
                double fromY = from.get(1).getAsDouble();
                double fromZ = from.get(2).getAsDouble();
                double toX = to.get(0).getAsDouble();
                double toY = to.get(1).getAsDouble();
                double toZ = to.get(2).getAsDouble();
                double xDiff = toX - fromX;
                double yDiff = toY - fromY;
                double zDiff = toZ - fromZ;
                if (xDiff < epsilon) {
                    diff = epsilon - xDiff;
                    halfDiff = diff / (double)2;
                    newFrom.add((Number)(fromX - halfDiff));
                    newTo.add((Number)(toX + halfDiff));
                } else {
                    newFrom.add((Number)fromX);
                    newTo.add((Number)toX);
                }
                if (yDiff < epsilon) {
                    diff = epsilon - yDiff;
                    halfDiff = diff / (double)2;
                    newFrom.add((Number)(fromY - halfDiff));
                    newTo.add((Number)(toY + halfDiff));
                } else {
                    newFrom.add((Number)fromY);
                    newTo.add((Number)toY);
                }
                if (zDiff < epsilon) {
                    diff = epsilon - zDiff;
                    halfDiff = diff / (double)2;
                    newFrom.add((Number)(fromZ - halfDiff));
                    newTo.add((Number)(toZ + halfDiff));
                } else {
                    newFrom.add((Number)fromZ);
                    newTo.add((Number)toZ);
                }
                elementObject.add("from", (JsonElement)newFrom);
                elementObject.add("to", (JsonElement)newTo);
            }
            json = gg.mantle.mod.client.utils.JsonKt.getClientGson().toJson((JsonElement)json);
        }
        catch (Exception e) {
            json = configuration;
        }
        Object modifiedConfiguration = json;
        Intrinsics.checkNotNullExpressionValue((Object)modifiedConfiguration, (String)"modifiedConfiguration");
        Object e = modifiedConfiguration;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = ((String)e).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        if (debugMode) {
            String filename = "cosmetic " + CosmeticsKt.getIdPrefix(cosmetic) + "-" + cosmetic.getId() + " (" + cosmetic.getName() + ").json";
            File file = FilesKt.resolve((File)new File(MantleConstants.getModDirectory(), "Cosmetics"), (String)filename);
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IllegalStateException(("Failed to create parent directories for " + filename + "!").toString());
            }
            try {
                JsonElement json2 = JsonKt.parseJson((String)modifiedConfiguration);
                String formatted = gg.mantle.mod.client.utils.JsonKt.getClientGson().toJson(json2);
                Intrinsics.checkNotNullExpressionValue((Object)formatted, (String)"formatted");
                FilesKt.writeText$default((File)file, (String)formatted, null, (int)2, null);
            }
            catch (Exception e2) {
                FilesKt.writeBytes((File)file, (byte[])bytes);
            }
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        InputStream inputStream2 = inputStream;
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        Charset charset3 = charset2;
        class_793 model = class_793.method_3437((Reader)new InputStreamReader(inputStream2, charset3));
        String string = cosmetic.getId();
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"model");
        cachedDeserializedModels.put(string, model);
        return model;
    }

    @Nullable
    public final class_1087 bake(@NotNull LoadedCosmetic cosmetic, @NotNull class_793 model) {
        boolean shouldCompute;
        Intrinsics.checkNotNullParameter((Object)cosmetic, (String)"cosmetic");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (loader == null) {
            throw new IllegalStateException("Attempted to bake cosmetics without a model loader!".toString());
        }
        boolean bl = shouldCompute = !cachedModels.containsKey(cosmetic.getEntry().getId());
        if (shouldCompute) {
            class_2960 class_29602 = CosmeticRegistry.INSTANCE.createTexture(cosmetic);
            if (class_29602 == null) {
                return null;
            }
            class_2960 identifier = class_29602;
            class_1044 modelTexture = class_310.method_1551().method_1531().method_4619(identifier);
            if (modelTexture instanceof AnimatableTexture) {
                CosmeticModelSprite sprite = new CosmeticModelSprite(identifier, (AnimatableTexture)modelTexture);
                var baker2 = new class_7775(model, sprite){
                    final /* synthetic */ class_793 $model;
                    final /* synthetic */ CosmeticModelSprite $sprite;
                    {
                        this.$model = $model;
                        this.$sprite = $sprite;
                    }

                    @NotNull
                    public class_793 getOrLoadModel(@NotNull class_2960 identifier) {
                        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                        return this.$model;
                    }

                    @NotNull
                    public class_1087 method_45873(@NotNull class_2960 identifier, @NotNull class_3665 modelBakeSettings) {
                        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
                        Intrinsics.checkNotNullParameter((Object)modelBakeSettings, (String)"modelBakeSettings");
                        class_1087 class_10872 = this.getOrLoadModel(identifier).method_4753((class_7775)this, arg_0 -> bake.baker.1.bake$lambda$0(this.$sprite, arg_0), modelBakeSettings, identifier);
                        Intrinsics.checkNotNull((Object)class_10872);
                        return class_10872;
                    }

                    private static final class_1058 bake$lambda$0(CosmeticModelSprite $sprite, class_4730 class_47302) {
                        Intrinsics.checkNotNullParameter((Object)$sprite, (String)"$sprite");
                        return $sprite;
                    }
                };
                class_1087 bakedModel = baker2.method_45873(identifier, (class_3665)class_1086.field_5350);
                cachedModels.put(cosmetic.getEntry().getId(), bakedModel);
                class_1087 class_10872 = bakedModel;
                Intrinsics.checkNotNull((Object)class_10872);
                return class_10872;
            }
        }
        return cachedModels.get(cosmetic.getEntry().getId());
    }

    static {
        cachedDeserializedModels = new LinkedHashMap();
        cachedModels = new LinkedHashMap();
    }
}

