/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.cosmetics;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import gg.mantle.mod.client.cosmetics.BaseCosmetic;
import gg.mantle.mod.client.cosmetics.CapeEntity;
import gg.mantle.mod.client.cosmetics.ModelEntity;
import gg.mantle.mod.client.exceptions.InvalidCosmeticTypeException;
import gg.mantle.mod.utils.JsonKt;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgg/mantle/mod/client/cosmetics/BaseCosmeticDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lgg/mantle/mod/client/cosmetics/BaseCosmetic;", "<init>", "()V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "type", "Lcom/google/gson/JsonDeserializationContext;", "ctx", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lgg/mantle/mod/client/cosmetics/BaseCosmetic;", "Mantle"})
public final class BaseCosmeticDeserializer
implements JsonDeserializer<BaseCosmetic> {
    @NotNull
    public static final BaseCosmeticDeserializer INSTANCE = new BaseCosmeticDeserializer();

    private BaseCosmeticDeserializer() {
    }

    @NotNull
    public BaseCosmetic deserialize(@NotNull JsonElement json, @NotNull Type type, @NotNull JsonDeserializationContext ctx) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected object, got " + json.getClass().getSimpleName() + "!");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"json.asJsonObject");
        String string = JsonKt.maybeGetString(jsonObject, "type");
        if (string == null) {
            throw new JsonSyntaxException("Missing 'type' key in cosmetic object!");
        }
        String cosmeticType = string;
        String string2 = cosmeticType;
        if (Intrinsics.areEqual((Object)string2, (Object)"model")) {
            clazz = ModelEntity.class;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"cape")) {
            clazz = CapeEntity.class;
        } else {
            throw new InvalidCosmeticTypeException("Unknown cosmetic type " + cosmeticType + "!");
        }
        Object object = ctx.deserialize(json, (Type)((Object)clazz));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.deserialize(\n       \u2026)\n            }\n        )");
        return (BaseCosmetic)object;
    }
}

