/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client.connection;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.essential.elementa.state.State;
import gg.mantle.mod.client.auth.AuthenticationManager;
import gg.mantle.mod.client.connection.BasePacket;
import gg.mantle.mod.client.connection.LocalConnectionManager;
import gg.mantle.mod.client.connection.impl.ActionPacket;
import gg.mantle.mod.client.connection.impl.AuthPacket;
import gg.mantle.mod.client.connection.impl.NotificationPacket;
import gg.mantle.mod.client.utils.ReconnectHandler;
import gg.mantle.mod.utils.JsonKt;
import gg.mantle.mod.utils.TesterEnvironment;
import java.io.File;
import java.net.ConnectException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ)\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010%\u001a\u00020\u00122\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010%\u001a\u00020\u00122\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b%\u0010)R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010*R(\u0010-\u001a\u0016\u0012\u0004\u0012\u00020\u000f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020'0,0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010/R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u00100\u00a8\u00062"}, d2={"Lgg/mantle/mod/client/connection/LocalConnection;", "Lorg/java_websocket/client/WebSocketClient;", "Ljava/net/URI;", "serverUri", "Ljava/io/File;", "previousConnectionFile", "Lgg/essential/elementa/state/State;", "", "connectionState", "Lgg/mantle/mod/client/utils/ReconnectHandler;", "reconnectHandler", "<init>", "(Ljava/net/URI;Ljava/io/File;Lgg/essential/elementa/state/State;Lgg/mantle/mod/client/utils/ReconnectHandler;)V", "", "code", "", "reason", "remote", "", "onClose", "(ILjava/lang/String;Z)V", "Ljava/lang/Exception;", "ex", "onError", "(Ljava/lang/Exception;)V", "Ljava/nio/ByteBuffer;", "bytes", "onMessage", "(Ljava/nio/ByteBuffer;)V", "message", "(Ljava/lang/String;)V", "Lorg/java_websocket/handshake/ServerHandshake;", "handshake", "onOpen", "(Lorg/java_websocket/handshake/ServerHandshake;)V", "Lcom/google/gson/JsonObject;", "json", "send", "(Lcom/google/gson/JsonObject;)V", "Lgg/mantle/mod/client/connection/BasePacket;", "packet", "(Lgg/mantle/mod/client/connection/BasePacket;)V", "Lgg/essential/elementa/state/State;", "", "Ljava/lang/Class;", "packetRegistry", "Ljava/util/Map;", "Ljava/io/File;", "Lgg/mantle/mod/client/utils/ReconnectHandler;", "Companion", "Mantle"})
@SourceDebugExtension(value={"SMAP\nLocalConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalConnection.kt\ngg/mantle/mod/client/connection/LocalConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n288#2,2:167\n*S KotlinDebug\n*F\n+ 1 LocalConnection.kt\ngg/mantle/mod/client/connection/LocalConnection\n*L\n55#1:167,2\n*E\n"})
public final class LocalConnection
extends WebSocketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File previousConnectionFile;
    @NotNull
    private final State<Boolean> connectionState;
    @NotNull
    private final ReconnectHandler reconnectHandler;
    @NotNull
    private final Map<String, Class<? extends BasePacket>> packetRegistry;
    @NotNull
    private static final Logger logger;
    private static final Gson gson;

    public LocalConnection(@NotNull URI serverUri, @NotNull File previousConnectionFile, @NotNull State<Boolean> connectionState, @NotNull ReconnectHandler reconnectHandler) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        Intrinsics.checkNotNullParameter((Object)previousConnectionFile, (String)"previousConnectionFile");
        Intrinsics.checkNotNullParameter(connectionState, (String)"connectionState");
        Intrinsics.checkNotNullParameter((Object)reconnectHandler, (String)"reconnectHandler");
        super(serverUri);
        this.previousConnectionFile = previousConnectionFile;
        this.connectionState = connectionState;
        this.reconnectHandler = reconnectHandler;
        this.packetRegistry = new LinkedHashMap();
        this.setTcpNoDelay(true);
        this.setConnectionLostTimeout(120);
        this.setReuseAddr(false);
        this.packetRegistry.put("action", ActionPacket.class);
        this.packetRegistry.put("notification", NotificationPacket.class);
        this.packetRegistry.put("auth", AuthPacket.class);
    }

    /*
     * WARNING - void declaration
     */
    public final void send(@NotNull BasePacket packet) {
        void $this$send_u24lambda_u242;
        String string;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Iterable $this$firstOrNull$iv = this.packetRegistry.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), packet.getClass())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null || (string = (String)entry.getKey()) == null) {
            return;
        }
        String type = string;
        if (this.isClosed() || !this.isOpen()) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "Attempted to send packet (" + type + ") while connection is closed");
            return;
        }
        JsonObject jsonObject = packet.handleSend(this);
        if (jsonObject == null) {
            LocalConnection $this$send_u24lambda_u241 = this;
            boolean bl = false;
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "Attempted to send no-op packet " + type);
            return;
        }
        JsonObject data = jsonObject;
        String $i$f$firstOrNull = string = new JsonObject();
        LocalConnection localConnection = this;
        boolean bl = false;
        $this$send_u24lambda_u242.addProperty("type", type);
        $this$send_u24lambda_u242.add("data", (JsonElement)data);
        localConnection.send((JsonObject)string);
    }

    public final void send(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (this.isClosed() || !this.isOpen()) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "Attempted to send packet while connection is closed");
            return;
        }
        this.send(gson.toJson((JsonElement)json));
    }

    public void onOpen(@NotNull ServerHandshake handshake) {
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
        this.reconnectHandler.reset();
        this.connectionState.set((Object)true);
        this.previousConnectionFile.createNewFile();
        FilesKt.writeText$default((File)this.previousConnectionFile, (String)"true", null, (int)2, null);
        TesterEnvironment.INSTANCE.printIfTesterAndInfo(logger, "Connected to Mantle app server - " + handshake.getHttpStatus() + ": " + handshake.getHttpStatusMessage());
        AuthenticationManager.INSTANCE.beginClientSetup(this);
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        if (code == 0) {
            this.reconnectHandler.reset();
        }
        String type = remote ? "REMOTE" : "SELF";
        this.connectionState.set((Object)false);
        LocalConnectionManager.INSTANCE.reconnect();
        if (code != -1) {
            String string = reason;
            if (string == null) {
                string = "'No applicable reason'";
            }
            String modifiedReason = string;
            TesterEnvironment.INSTANCE.printIfTesterAndInfo(logger, "Disconnected from Mantle app server - [" + type + "] " + code + ": " + modifiedReason);
        }
    }

    public void onMessage(@NotNull ByteBuffer bytes) {
        BasePacket basePacket;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte[] byArray = bytes.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bytes.array()");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string = new String(byArray2, charset2);
        if (!JsonKt.isValidJson(string)) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "Received invalid JSON from Mantle app server: " + string);
            return;
        }
        JsonElement parsedJson = JsonKt.parseJson(string);
        if (!parsedJson.isJsonObject()) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "JSON from Mantle app server is not an object: " + string);
            return;
        }
        JsonObject json = parsedJson.getAsJsonObject();
        if (!json.has("type")) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "JSON from Mantle app server does not have a type: " + string);
            return;
        }
        JsonElement rawType = json.get("type");
        if (!rawType.isJsonPrimitive()) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "JSON from Mantle app server has a non-primitive type: " + string);
            return;
        }
        String type = rawType.getAsString();
        if (!this.packetRegistry.containsKey(type)) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "JSON from Mantle app server has an unknown type: " + string);
            return;
        }
        Class<? extends BasePacket> clazz = this.packetRegistry.get(type);
        if (clazz == null) {
            return;
        }
        Class<? extends BasePacket> clazz2 = clazz;
        try {
            basePacket = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            TesterEnvironment.INSTANCE.printIfTesterAndWarn(logger, "Failed to create packet instance for type " + type, e);
            return;
        }
        BasePacket packet = basePacket;
        JsonElement rawData = json.get("data");
        packet.handleReceive(this, rawData);
    }

    public void onMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(message.toByteArray())");
        this.onMessage(byteBuffer);
    }

    public void onError(@NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (ex instanceof ConnectException) {
            LocalConnectionManager.INSTANCE.reconnect();
        } else {
            TesterEnvironment.INSTANCE.printIfTesterAndError(logger, "Error in Mantle app server connection", ex);
        }
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger()");
        LocalConnection.logger = logger;
        gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).serializeNulls().create();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lgg/mantle/mod/client/connection/LocalConnection$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "Mantle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

