/*
 * Decompiled with CFR 0.152.
 */
package gg.mantle.mod.client;

import com.google.common.base.Stopwatch;
import dev.deftu.eventbus.BuilderKt;
import dev.deftu.eventbus.EventBus;
import dev.deftu.eventbus.EventPriority;
import dev.deftu.eventbus.EventSubscriber;
import dev.deftu.eventbus.collection.ConcurrentSubscriberArrayList;
import dev.deftu.eventbus.collection.SubscriberArrayList;
import dev.deftu.eventbus.invokers.Invoker;
import gg.essential.elementa.font.FontProvider;
import gg.essential.universal.UDesktop;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMinecraft;
import gg.essential.universal.UScreen;
import gg.mantle.mod.client.Mantle;
import gg.mantle.mod.client.auth.AuthenticationManager;
import gg.mantle.mod.client.connection.LocalConnectionManager;
import gg.mantle.mod.client.cosmetics.CosmeticRegistry;
import gg.mantle.mod.client.dev.MantleDev;
import gg.mantle.mod.client.events.AuthEvent;
import gg.mantle.mod.client.events.KeyboardAction;
import gg.mantle.mod.client.events.KeyboardInputEvent;
import gg.mantle.mod.client.events.UserUpdateEvent;
import gg.mantle.mod.client.events.impl.EventPropagator;
import gg.mantle.mod.client.gui.CustomFontProvider;
import gg.mantle.mod.client.gui.extensions.IndicatorExtension;
import gg.mantle.mod.client.gui.extensions.ScreenExtension;
import gg.mantle.mod.client.gui.extensions.StartupPopupExtension;
import gg.mantle.mod.client.gui.extensions.StoreWardrobeExtension;
import gg.mantle.mod.client.keybindings.KeyBindManager;
import gg.mantle.mod.client.notifications.Notification;
import gg.mantle.mod.client.notifications.NotificationManager;
import gg.mantle.mod.client.sse.ServerSessionManager;
import gg.mantle.mod.client.statistics.StatisticsManager;
import gg.mantle.mod.client.user.StoreManager;
import gg.mantle.mod.client.user.UserCacheManager;
import gg.mantle.mod.client.user.UserEntity;
import gg.mantle.mod.client.user.WalletManager;
import gg.mantle.mod.client.user.WardrobeCacheManager;
import gg.mantle.mod.client.utils.GameProfileWrapper;
import gg.mantle.mod.client.utils.UtilsKt;
import gg.mantle.mod.client.utils.gamemode.UGameMode;
import gg.mantle.mod.utils.CompatibilityKt;
import gg.mantle.mod.utils.TesterEnvironment;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_433;
import net.minecraft.class_442;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\r\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0003J\r\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011R*\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00128\u0006@BX\u0087.\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u0012\u0004\b\u001e\u0010\u0003\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001f\u0010\u0006R \u0010\"\u001a\u00020!8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u0012\u0004\b&\u0010\u0003\u001a\u0004\b$\u0010%R$\u0010'\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e8\u0006@BX\u0086.\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lgg/mantle/mod/client/Mantle;", "", "<init>", "()V", "", "hasSelfUser", "()Z", "", "initialize", "initializeEventListeners", "initializeScreenExtensions", "openDownloadPage", "preInitialize", "preInitializeFonts", "Lgg/mantle/mod/client/user/UserEntity;", "newUser", "setSelfUser", "(Lgg/mantle/mod/client/user/UserEntity;)V", "Lgg/essential/elementa/font/FontProvider;", "<set-?>", "bahnschriftFontProvider", "Lgg/essential/elementa/font/FontProvider;", "getBahnschriftFontProvider", "()Lgg/essential/elementa/font/FontProvider;", "getBahnschriftFontProvider$annotations", "Ldev/deftu/eventbus/EventBus;", "eventBus", "Ldev/deftu/eventbus/EventBus;", "getEventBus", "()Ldev/deftu/eventbus/EventBus;", "getEventBus$annotations", "isCrackedUser", "Z", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "getLogger$annotations", "selfUser", "Lgg/mantle/mod/client/user/UserEntity;", "getSelfUser", "()Lgg/mantle/mod/client/user/UserEntity;", "Mantle"})
@SourceDebugExtension(value={"SMAP\nMantle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mantle.kt\ngg/mantle/mod/client/Mantle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 eventbus.kt\ndev/deftu/eventbus/EventbusKt\n*L\n1#1,204:1\n1#2:205\n151#3,11:206\n151#3,11:217\n151#3,11:228\n*S KotlinDebug\n*F\n+ 1 Mantle.kt\ngg/mantle/mod/client/Mantle\n*L\n118#1:206,11\n134#1:217,11\n138#1:228,11\n*E\n"})
public final class Mantle {
    @NotNull
    public static final Mantle INSTANCE = new Mantle();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final EventBus eventBus;
    private static boolean isCrackedUser;
    private static UserEntity selfUser;
    private static FontProvider bahnschriftFontProvider;

    private Mantle() {
    }

    @NotNull
    public static final Logger getLogger() {
        return logger;
    }

    @JvmStatic
    public static /* synthetic */ void getLogger$annotations() {
    }

    @NotNull
    public static final EventBus getEventBus() {
        return eventBus;
    }

    @JvmStatic
    public static /* synthetic */ void getEventBus$annotations() {
    }

    public final boolean isCrackedUser() {
        return isCrackedUser;
    }

    @NotNull
    public final UserEntity getSelfUser() {
        UserEntity userEntity = selfUser;
        if (userEntity != null) {
            return userEntity;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"selfUser");
        return null;
    }

    @NotNull
    public static final FontProvider getBahnschriftFontProvider() {
        FontProvider fontProvider = bahnschriftFontProvider;
        if (fontProvider != null) {
            return fontProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"bahnschriftFontProvider");
        return null;
    }

    @JvmStatic
    public static /* synthetic */ void getBahnschriftFontProvider$annotations() {
    }

    public final void preInitialize() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Pre-initializing Mantle v0.10.1...");
        TesterEnvironment.INSTANCE.initialize();
        KeyBindManager.INSTANCE.initialize();
        MantleDev.INSTANCE.maybeSetupDev();
        if (!GameProfileWrapper.Companion.getLocalProfile().isCracked()) {
            logger.info("Starting authentication process...");
            AuthenticationManager.INSTANCE.beginAuthentication();
        } else {
            logger.info("User is playing cracked Minecraft, not authentication.");
            isCrackedUser = true;
        }
        Stopwatch stopwatch2 = stopwatch.stop();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"stopwatch.stop()");
        logger.info("Pre-initialization took " + UtilsKt.asMillis(stopwatch2) + "ms!");
        this.preInitializeFonts();
        this.initialize();
    }

    private final void preInitializeFonts() {
        CustomFontProvider customFontProvider;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Pre-initializing Mantle fonts");
        CustomFontProvider $this$preInitializeFonts_u24lambda_u240 = customFontProvider = new CustomFontProvider("/assets/mantle/fonts/bahnschrift.TTF", 0, 0.0f, 6, null);
        boolean bl = false;
        $this$preInitializeFonts_u24lambda_u240.preInitialize();
        bahnschriftFontProvider = customFontProvider;
        Stopwatch stopwatch2 = stopwatch.stop();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"stopwatch.stop()");
        logger.info("Font pre-initialization took " + UtilsKt.asMillis(stopwatch2) + "ms!");
    }

    private final void initialize() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Initializing Mantle v0.10.1...");
        EventPropagator.INSTANCE.initialize();
        NotificationManager.INSTANCE.initialize();
        Stopwatch stopwatch2 = stopwatch.stop();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"stopwatch.stop()");
        logger.info("Initialization took " + UtilsKt.asMillis(stopwatch2) + "ms!");
        this.initializeScreenExtensions();
        this.initializeEventListeners();
    }

    private final void initializeScreenExtensions() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Initializing screen extensions...");
        ScreenExtension.Companion.register(class_442.class, StartupPopupExtension.class);
        ScreenExtension.Companion.register(class_442.class, IndicatorExtension.class);
        ScreenExtension.Companion.register(class_442.class, StoreWardrobeExtension.class);
        ScreenExtension.Companion.register(class_433.class, IndicatorExtension.class);
        ScreenExtension.Companion.register(class_433.class, StoreWardrobeExtension.class);
        Stopwatch stopwatch2 = stopwatch.stop();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"stopwatch.stop()");
        logger.info("Screen extensions initialization took " + UtilsKt.asMillis(stopwatch2) + "ms!");
    }

    private final void initializeEventListeners() {
        EventBus $this$on_u24default$iv = eventBus;
        EventPriority priority$iv = EventPriority.NORMAL;
        boolean $i$f$on = false;
        Invoker.SubscriberMethod method$iv = new Invoker.SubscriberMethod(){

            public final void invoke(Object arg) {
                Object object = arg;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type gg.mantle.mod.client.events.AuthEvent");
                }
                AuthEvent $this$initializeEventListeners_u24lambda_u241 = (AuthEvent)object;
                boolean bl = false;
                Stopwatch stopwatch = Stopwatch.createStarted();
                Mantle.getLogger().info("User authenticated, initializing gated features...");
                LocalConnectionManager.INSTANCE.initialize();
                ServerSessionManager.INSTANCE.initialize();
                CosmeticRegistry.INSTANCE.initialize();
                UserCacheManager.INSTANCE.initialize();
                WalletManager.INSTANCE.initialize();
                WardrobeCacheManager.INSTANCE.initialize();
                StoreManager.INSTANCE.initialize();
                StatisticsManager.INSTANCE.initialize();
                Logger logger = Mantle.getLogger();
                Stopwatch stopwatch2 = stopwatch.stop();
                Intrinsics.checkNotNullExpressionValue((Object)stopwatch2, (String)"stopwatch.stop()");
                logger.info("Initialization of gated features took " + UtilsKt.asMillis(stopwatch2) + "ms!");
            }
        };
        EventSubscriber subscriber$iv = new EventSubscriber((Object)$this$on_u24default$iv, priority$iv, method$iv);
        ((List)$this$on_u24default$iv.getSubscribers().computeIfAbsent(AuthEvent.class, new Function($this$on_u24default$iv){
            final /* synthetic */ EventBus $this_on;
            {
                this.$this_on = $receiver;
            }

            public final List<EventSubscriber> apply(Class<?> it) {
                return this.$this_on.getThreadSafety() ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList();
            }
        })).add(subscriber$iv);
        Function0 cfr_ignored_0 = (Function0)new Function0<Unit>($this$on_u24default$iv, subscriber$iv){
            final /* synthetic */ EventBus $this_on;
            final /* synthetic */ EventSubscriber $subscriber;
            {
                this.$this_on = $receiver;
                this.$subscriber = $subscriber;
                super(0);
            }

            public final void invoke() {
                block0: {
                    List list = (List)this.$this_on.getSubscribers().get(AuthEvent.class);
                    if (list == null) break block0;
                    list.remove(this.$subscriber);
                }
            }
        };
        $this$on_u24default$iv = eventBus;
        priority$iv = EventPriority.NORMAL;
        $i$f$on = false;
        method$iv = new Invoker.SubscriberMethod(){

            public final void invoke(Object arg) {
                Object object = arg;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type gg.mantle.mod.client.events.UserUpdateEvent");
                }
                UserUpdateEvent $this$initializeEventListeners_u24lambda_u242 = (UserUpdateEvent)object;
                boolean bl = false;
                Mantle.access$setSelfUser$p($this$initializeEventListeners_u24lambda_u242.getEntity());
            }
        };
        subscriber$iv = new EventSubscriber((Object)$this$on_u24default$iv, priority$iv, method$iv);
        ((List)$this$on_u24default$iv.getSubscribers().computeIfAbsent(UserUpdateEvent.class, new Function($this$on_u24default$iv){
            final /* synthetic */ EventBus $this_on;
            {
                this.$this_on = $receiver;
            }

            public final List<EventSubscriber> apply(Class<?> it) {
                return this.$this_on.getThreadSafety() ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList();
            }
        })).add(subscriber$iv);
        Function0 cfr_ignored_1 = (Function0)new Function0<Unit>($this$on_u24default$iv, subscriber$iv){
            final /* synthetic */ EventBus $this_on;
            final /* synthetic */ EventSubscriber $subscriber;
            {
                this.$this_on = $receiver;
                this.$subscriber = $subscriber;
                super(0);
            }

            public final void invoke() {
                block0: {
                    List list = (List)this.$this_on.getSubscribers().get(UserUpdateEvent.class);
                    if (list == null) break block0;
                    list.remove(this.$subscriber);
                }
            }
        };
        $this$on_u24default$iv = eventBus;
        priority$iv = EventPriority.NORMAL;
        $i$f$on = false;
        method$iv = new Invoker.SubscriberMethod(){

            public final void invoke(Object arg) {
                Object object = arg;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type gg.mantle.mod.client.events.KeyboardInputEvent");
                }
                KeyboardInputEvent $this$initializeEventListeners_u24lambda_u244 = (KeyboardInputEvent)object;
                boolean bl = false;
                if ($this$initializeEventListeners_u24lambda_u244.getAction() == KeyboardAction.RELEASE && UtilsKt.isInScreen() && UScreen.Companion.getCurrentScreen() instanceof class_433 && $this$initializeEventListeners_u24lambda_u244.getCode() == UKeyboard.KEY_M && $this$initializeEventListeners_u24lambda_u244.getModifiers().getCtrl() && $this$initializeEventListeners_u24lambda_u244.getModifiers().getShift()) {
                    boolean bl2;
                    StringBuilder stringBuilder;
                    StringBuilder $this$initializeEventListeners_u24lambda_u244_u24lambda_u243;
                    StringBuilder stringBuilder2;
                    block5: {
                        Mantle.getLogger().info("Copying debug info to clipboard...");
                        $this$initializeEventListeners_u24lambda_u244_u24lambda_u243 = stringBuilder2 = new StringBuilder();
                        boolean bl3 = false;
                        StringBuilder stringBuilder3 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("## Account");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder4 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Username:** " + UMinecraft.getMinecraft().method_1548().method_1676());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder5 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**UUID:** " + GameProfileWrapper.Companion.getLocalProfile().getId());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder6 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Mod Authenticated:** " + Mantle.access$initializeEventListeners$lambda$4$lambda$3$toText(AuthenticationManager.INSTANCE.isAuthenticated()));
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder7 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**App Connected:** " + Mantle.access$initializeEventListeners$lambda$4$lambda$3$toText(LocalConnectionManager.isConnected()));
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder8 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Cracked Status:** " + Mantle.access$initializeEventListeners$lambda$4$lambda$3$toText(Mantle.INSTANCE.isCrackedUser()));
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder9 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("## Instance");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder10 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Version:** " + gg.mantle.mod.utils.UtilsKt.getGameVersion());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder11 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Server Name:** " + UtilsKt.resolveServerName());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder12 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Mod Version:** 0.10.1");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder13 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("## Session");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13.append('\n'), (String)"append(...)");
                        StringBuilder stringBuilder14 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Gamemode:** " + UGameMode.Companion.getCurrentGameMode().getHumanReadableName());
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14.append('\n'), (String)"append(...)");
                        stringBuilder = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243;
                        Iterable $this$any$iv = UGameMode.Companion.toGameModes(UtilsKt.getOtherPlayers());
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                UGameMode p0 = (UGameMode)((Object)element$iv);
                                boolean bl4 = false;
                                if (!p0.isCreative()) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    StringBuilder stringBuilder15 = stringBuilder.append("**Is with Creative Players:** " + Mantle.access$initializeEventListeners$lambda$4$lambda$3$toText(bl2));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder16 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("## Compatibility Checklist");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder17 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Optifine:** " + Mantle.access$initializeEventListeners$lambda$4$lambda$3$toText(CompatibilityKt.hasOptifine()));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17.append('\n'), (String)"append(...)");
                    StringBuilder stringBuilder18 = $this$initializeEventListeners_u24lambda_u244_u24lambda_u243.append("**Essential:** " + Mantle.access$initializeEventListeners$lambda$4$lambda$3$toText(CompatibilityKt.hasEssential()));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append(...)");
                    String string = stringBuilder2.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    UDesktop.setClipboardString((String)string);
                    NotificationManager.INSTANCE.push(new Notification("Debug Info Copied", "Copied debug info to your clipboard!", 10000, null, 8, null));
                }
            }
        };
        subscriber$iv = new EventSubscriber((Object)$this$on_u24default$iv, priority$iv, method$iv);
        ((List)$this$on_u24default$iv.getSubscribers().computeIfAbsent(KeyboardInputEvent.class, new Function($this$on_u24default$iv){
            final /* synthetic */ EventBus $this_on;
            {
                this.$this_on = $receiver;
            }

            public final List<EventSubscriber> apply(Class<?> it) {
                return this.$this_on.getThreadSafety() ? (List)new ConcurrentSubscriberArrayList() : (List)new SubscriberArrayList();
            }
        })).add(subscriber$iv);
        Function0 cfr_ignored_2 = (Function0)new Function0<Unit>($this$on_u24default$iv, subscriber$iv){
            final /* synthetic */ EventBus $this_on;
            final /* synthetic */ EventSubscriber $subscriber;
            {
                this.$this_on = $receiver;
                this.$subscriber = $subscriber;
                super(0);
            }

            public final void invoke() {
                block0: {
                    List list = (List)this.$this_on.getSubscribers().get(KeyboardInputEvent.class);
                    if (list == null) break block0;
                    list.remove(this.$subscriber);
                }
            }
        };
    }

    public final void openDownloadPage() {
        try {
            URI uRI = URI.create("https://mantle.gg/download");
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"https://mantle.gg/download\")");
            UDesktop.browse((URI)uRI);
        }
        catch (Throwable t) {
            logger.error("Failed to open download page", t);
        }
    }

    public final void setSelfUser(@NotNull UserEntity newUser) {
        Intrinsics.checkNotNullParameter((Object)newUser, (String)"newUser");
        selfUser = newUser;
    }

    public final boolean hasSelfUser() {
        return selfUser != null;
    }

    private static final String initializeEventListeners$lambda$4$lambda$3$toText(boolean $this$initializeEventListeners_u24lambda_u244_u24lambda_u243_u24toText) {
        return $this$initializeEventListeners_u24lambda_u244_u24lambda_u243_u24toText ? "`YES`" : "`NO`";
    }

    public static final /* synthetic */ void access$setSelfUser$p(UserEntity userEntity) {
        selfUser = userEntity;
    }

    public static final /* synthetic */ String access$initializeEventListeners$lambda$4$lambda$3$toText(boolean $receiver) {
        return Mantle.initializeEventListeners$lambda$4$lambda$3$toText($receiver);
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger()");
        Mantle.logger = logger;
        eventBus = BuilderKt.bus((Function1)eventBus.1.INSTANCE);
    }
}

