/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.formattingrules;

import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2583;
import org.jetbrains.annotations.Nullable;

public class HighlightPlaceholdersFormattingRule
extends TextEditorFormattingRule {
    protected class_2583[] colorsByLevelOfNesting;
    protected Map<TextEditorLine, List<PlaceholderIndexPair>> placeholderIndexes;

    public HighlightPlaceholdersFormattingRule() {
        this.colorsByLevelOfNesting = new class_2583[]{class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_1.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_2.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_3.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_4.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_5.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_6.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_7.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_8.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_9.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_10.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_11.getColorInt()), class_2583.field_24360.method_36139(UIBase.getUIColorTheme().text_editor_text_formatting_nested_text_color_12.getColorInt())};
        this.placeholderIndexes = new HashMap<TextEditorLine, List<PlaceholderIndexPair>>();
    }

    @Override
    public void resetRule(TextEditorScreen editor) {
        this.placeholderIndexes.clear();
    }

    @Override
    @Nullable
    public class_2583 getStyle(char atCharacterInLine, int atCharacterIndexInLine, int cursorPosInLine, TextEditorLine inLine, int atCharacterIndexTotal, TextEditorScreen editor) {
        int depth;
        int endIndex;
        String s = String.valueOf(atCharacterInLine);
        if (s.equals("{") && inLine.method_1882().substring(atCharacterIndexInLine).startsWith("{\"placeholder\":\"") && (endIndex = HighlightPlaceholdersFormattingRule.findPlaceholderEndIndex(inLine.method_1882(), atCharacterIndexInLine)) > -1) {
            if (!this.placeholderIndexes.containsKey((Object)inLine)) {
                this.placeholderIndexes.put(inLine, new ArrayList());
            }
            this.placeholderIndexes.get((Object)inLine).add(new PlaceholderIndexPair(atCharacterIndexInLine, endIndex));
        }
        if ((depth = this.getDepth(atCharacterIndexInLine, inLine)) > -1) {
            if (depth > this.colorsByLevelOfNesting.length - 1) {
                depth = this.colorsByLevelOfNesting.length - 1;
            }
            return this.colorsByLevelOfNesting[depth];
        }
        return null;
    }

    private int getDepth(int charIndex, TextEditorLine line) {
        if (this.placeholderIndexes.containsKey((Object)line)) {
            int depth = -1;
            for (PlaceholderIndexPair p : this.placeholderIndexes.get((Object)line)) {
                if (charIndex < p.start || charIndex > p.end) continue;
                ++depth;
            }
            return depth;
        }
        return -1;
    }

    private static int findPlaceholderEndIndex(String in, int startIndex) {
        if (in.substring(startIndex).startsWith("{") && (startIndex == 0 || !in.substring(startIndex - 1).startsWith("\\"))) {
            int currentIndex = startIndex + 1;
            int depth = 0;
            for (char c : in.substring(startIndex + 1).toCharArray()) {
                if (String.valueOf(c).equals("{") && !in.substring(currentIndex - 1).startsWith("\\")) {
                    ++depth;
                } else if (String.valueOf(c).equals("}") && !in.substring(currentIndex - 1).startsWith("\\")) {
                    if (depth <= 0) {
                        return currentIndex;
                    }
                    --depth;
                }
                ++currentIndex;
            }
        }
        return -1;
    }

    public static class PlaceholderIndexPair {
        int start;
        int end;

        public PlaceholderIndexPair(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

