/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text.markdown;

import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownTextFragment;
import java.util.Objects;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;

public class MarkdownTextBuilder {
    protected StringBuilder builder = new StringBuilder();

    @NotNull
    public static MarkdownTextBuilder create() {
        return new MarkdownTextBuilder();
    }

    public MarkdownTextBuilder addLine(@NotNull String line) {
        this.builder.append(Objects.requireNonNull(line)).append("\n");
        return this;
    }

    public MarkdownTextBuilder addLocalizedLine(@NotNull String key, Object ... placeholders) {
        return this.addLine(class_1074.method_4662((String)key, (Object[])placeholders));
    }

    public MarkdownTextBuilder addHeadline(@NotNull MarkdownTextFragment.HeadlineType headlineType, @NotNull String headline) {
        Objects.requireNonNull(headlineType);
        if (headlineType == MarkdownTextFragment.HeadlineType.BIG) {
            headline = "### " + (String)headline;
        } else if (headlineType == MarkdownTextFragment.HeadlineType.BIGGER) {
            headline = "## " + (String)headline;
        } else if (headlineType == MarkdownTextFragment.HeadlineType.BIGGEST) {
            headline = "# " + (String)headline;
        }
        return this.addLine((String)headline);
    }

    public MarkdownTextBuilder addLocalizedHeadline(@NotNull MarkdownTextFragment.HeadlineType headlineType, @NotNull String key, Object ... placeholders) {
        return this.addHeadline(headlineType, class_1074.method_4662((String)key, (Object[])placeholders));
    }

    public MarkdownTextBuilder addEmptyLine() {
        return this.addLine("");
    }

    @NotNull
    public String build() {
        return this.builder.toString();
    }

    public String toString() {
        return this.build();
    }
}

