/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.slider.v2;

import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.ExecutableBlockDeserializer;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.SerializedElement;
import de.keksuccino.fancymenu.customization.element.elements.slider.v2.SliderEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.slider.v2.SliderElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderElementBuilder
extends ElementBuilder<SliderElement, SliderEditorElement> {
    public SliderElementBuilder() {
        super("slider_v2");
    }

    @Override
    @NotNull
    public SliderElement buildDefaultInstance() {
        SliderElement i = new SliderElement(this);
        i.baseWidth = 100;
        i.baseHeight = 20;
        i.label = "New Slider: $$value";
        i.listValues.addAll(List.of("some_value", "another_value", "third_value"));
        i.minRangeValue = 0.0;
        i.maxRangeValue = 20.0;
        return i;
    }

    @Override
    public SliderElement deserializeElement(@NotNull SerializedElement serialized) {
        AbstractExecutableBlock b;
        String executableBlockId;
        SliderElement.SliderType t;
        SliderElement element = this.buildDefaultInstance();
        String sliderTypeString = serialized.getValue("slider_type");
        if (sliderTypeString != null && (t = SliderElement.SliderType.getByName(sliderTypeString)) != null) {
            element.type = t;
        }
        element.preSelectedValue = serialized.getValue("pre_selected_value");
        element.label = serialized.getValue("slider_label");
        element.minRangeValue = this.deserializeNumber(Double.class, element.minRangeValue, serialized.getValue("min_range_value"));
        element.maxRangeValue = this.deserializeNumber(Double.class, element.maxRangeValue, serialized.getValue("max_range_value"));
        element.roundingDecimalPlace = this.deserializeNumber(Integer.class, element.roundingDecimalPlace, serialized.getValue("rounding_decimal_place"));
        ArrayList<Pair> listValueEntries = new ArrayList<Pair>();
        serialized.getProperties().forEach((key, value) -> {
            if (key.startsWith("slider_list_value_")) {
                listValueEntries.add(Pair.of((Object)key, (Object)value));
            }
        });
        listValueEntries.sort(Comparator.comparingInt(value -> {
            String key = (String)value.getKey();
            key = new StringBuilder(key).reverse().toString();
            if (MathUtils.isInteger((String)(key = new StringBuilder(key.split("_", 2)[0]).reverse().toString()))) {
                return Integer.parseInt(key);
            }
            return 0;
        }));
        if (!listValueEntries.isEmpty()) {
            element.listValues.clear();
        }
        listValueEntries.forEach(pair -> element.listValues.add((String)pair.getValue()));
        if (element.listValues.size() < 2) {
            element.listValues.add("placeholder_value");
        }
        if ((executableBlockId = serialized.getValue("slider_element_executable_block_identifier")) != null && (b = ExecutableBlockDeserializer.deserializeWithIdentifier(serialized, executableBlockId)) instanceof GenericExecutableBlock) {
            GenericExecutableBlock g;
            element.executableBlock = g = (GenericExecutableBlock)b;
        }
        element.tooltip = serialized.getValue("tooltip");
        element.handleTextureNormal = SliderElementBuilder.deserializeImageResourceSupplier(serialized.getValue("handle_texture_normal"));
        element.handleTextureHover = SliderElementBuilder.deserializeImageResourceSupplier(serialized.getValue("handle_texture_hovered"));
        element.handleTextureInactive = SliderElementBuilder.deserializeImageResourceSupplier(serialized.getValue("handle_texture_inactive"));
        element.handleAnimationNormal = serialized.getValue("handle_animation_normal");
        element.handleAnimationHover = serialized.getValue("handle_animation_hovered");
        element.handleAnimationInactive = serialized.getValue("handle_animation_inactive");
        element.sliderBackgroundTextureNormal = SliderElementBuilder.deserializeImageResourceSupplier(serialized.getValue("slider_background_texture_normal"));
        element.sliderBackgroundTextureHighlighted = SliderElementBuilder.deserializeImageResourceSupplier(serialized.getValue("slider_background_texture_highlighted"));
        element.sliderBackgroundAnimationNormal = serialized.getValue("slider_background_animation_normal");
        element.sliderBackgroundAnimationHighlighted = serialized.getValue("slider_background_animation_highlighted");
        element.loopBackgroundAnimations = this.deserializeBoolean(element.loopBackgroundAnimations, serialized.getValue("loop_background_animations"));
        element.restartBackgroundAnimationsOnHover = this.deserializeBoolean(element.restartBackgroundAnimationsOnHover, serialized.getValue("restart_background_animations"));
        element.nineSliceCustomBackground = this.deserializeBoolean(element.nineSliceCustomBackground, serialized.getValue("nine_slice_custom_background"));
        element.nineSliceBorderX = this.deserializeNumber(Integer.class, element.nineSliceBorderX, serialized.getValue("nine_slice_border_x"));
        element.nineSliceBorderY = this.deserializeNumber(Integer.class, element.nineSliceBorderY, serialized.getValue("nine_slice_border_y"));
        element.nineSliceSliderHandle = this.deserializeBoolean(element.nineSliceSliderHandle, serialized.getValue("nine_slice_slider_handle"));
        element.nineSliceSliderHandleBorderX = this.deserializeNumber(Integer.class, element.nineSliceSliderHandleBorderX, serialized.getValue("nine_slice_slider_handle_border_x"));
        element.nineSliceSliderHandleBorderY = this.deserializeNumber(Integer.class, element.nineSliceSliderHandleBorderY, serialized.getValue("nine_slice_slider_handle_border_y"));
        element.navigatable = this.deserializeBoolean(element.navigatable, serialized.getValue("navigatable"));
        element.buildSlider();
        element.prepareExecutableBlock();
        return element;
    }

    @Override
    @Nullable
    public SliderElement deserializeElementInternal(@NotNull SerializedElement serialized) {
        SliderElement element = (SliderElement)super.deserializeElementInternal(serialized);
        if (element != null) {
            element.prepareLoadingRequirementContainer();
        }
        return element;
    }

    @Override
    protected SerializedElement serializeElement(@NotNull SliderElement element, @NotNull SerializedElement serializeTo) {
        serializeTo.putProperty("slider_type", element.type.getName());
        serializeTo.putProperty("pre_selected_value", element.preSelectedValue);
        serializeTo.putProperty("slider_label", element.label);
        serializeTo.putProperty("min_range_value", "" + element.minRangeValue);
        serializeTo.putProperty("max_range_value", "" + element.maxRangeValue);
        serializeTo.putProperty("rounding_decimal_place", "" + element.roundingDecimalPlace);
        int i = 0;
        for (String s : element.listValues) {
            serializeTo.putProperty("slider_list_value_" + i, s);
            ++i;
        }
        serializeTo.putProperty("slider_element_executable_block_identifier", element.executableBlock.getIdentifier());
        element.executableBlock.serializeToExistingPropertyContainer(serializeTo);
        serializeTo.putProperty("tooltip", element.tooltip);
        if (element.handleTextureNormal != null) {
            serializeTo.putProperty("handle_texture_normal", element.handleTextureNormal.getSourceWithPrefix());
        }
        if (element.handleTextureHover != null) {
            serializeTo.putProperty("handle_texture_hovered", element.handleTextureHover.getSourceWithPrefix());
        }
        if (element.handleTextureInactive != null) {
            serializeTo.putProperty("handle_texture_inactive", element.handleTextureInactive.getSourceWithPrefix());
        }
        serializeTo.putProperty("handle_animation_normal", element.handleAnimationNormal);
        serializeTo.putProperty("handle_animation_hovered", element.handleAnimationHover);
        serializeTo.putProperty("handle_animation_inactive", element.handleAnimationInactive);
        serializeTo.putProperty("restart_background_animations", "" + element.restartBackgroundAnimationsOnHover);
        serializeTo.putProperty("loop_background_animations", "" + element.loopBackgroundAnimations);
        if (element.sliderBackgroundTextureNormal != null) {
            serializeTo.putProperty("slider_background_texture_normal", element.sliderBackgroundTextureNormal.getSourceWithPrefix());
        }
        if (element.sliderBackgroundTextureHighlighted != null) {
            serializeTo.putProperty("slider_background_texture_highlighted", element.sliderBackgroundTextureHighlighted.getSourceWithPrefix());
        }
        serializeTo.putProperty("slider_background_animation_normal", element.sliderBackgroundAnimationNormal);
        serializeTo.putProperty("slider_background_animation_highlighted", element.sliderBackgroundAnimationHighlighted);
        serializeTo.putProperty("nine_slice_custom_background", "" + element.nineSliceCustomBackground);
        serializeTo.putProperty("nine_slice_border_x", "" + element.nineSliceBorderX);
        serializeTo.putProperty("nine_slice_border_y", "" + element.nineSliceBorderY);
        serializeTo.putProperty("nine_slice_slider_handle", "" + element.nineSliceSliderHandle);
        serializeTo.putProperty("nine_slice_slider_handle_border_x", "" + element.nineSliceSliderHandleBorderX);
        serializeTo.putProperty("nine_slice_slider_handle_border_y", "" + element.nineSliceSliderHandleBorderY);
        serializeTo.putProperty("navigatable", "" + element.navigatable);
        return serializeTo;
    }

    @Override
    @NotNull
    public SliderEditorElement wrapIntoEditorElement(@NotNull SliderElement element, @NotNull LayoutEditorScreen editor) {
        return new SliderEditorElement(element, editor);
    }

    @Override
    @NotNull
    public class_2561 getDisplayName(@Nullable AbstractElement element) {
        return class_2561.method_43471((String)"fancymenu.elements.slider.v2");
    }

    @Override
    @Nullable
    public class_2561[] getDescription(@Nullable AbstractElement element) {
        return LocalizationUtils.splitLocalizedLines("fancymenu.elements.slider.v2.desc", new String[0]);
    }
}

