/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.progressbar;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    public BarDirection direction = BarDirection.RIGHT;
    public DrawableColor barColor = DrawableColor.of(new Color(82, 149, 255));
    @Nullable
    public ResourceSupplier<ITexture> barTextureSupplier;
    public DrawableColor backgroundColor = DrawableColor.of(new Color(171, 200, 247));
    @Nullable
    public ResourceSupplier<ITexture> backgroundTextureSupplier;
    public boolean useProgressForElementAnchor = false;
    public String progressSource = null;
    public ProgressValueMode progressValueMode = ProgressValueMode.PERCENTAGE;
    protected int lastProgressX = 0;
    protected int lastProgressY = 0;
    protected int lastProgressWidth = 0;
    protected int lastProgressHeight = 0;
    protected float renderProgress = 0.0f;

    public ProgressBarElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.shouldRender()) {
            return;
        }
        this.renderBackground(graphics);
        this.renderProgress(graphics);
    }

    protected void renderProgress(@NotNull class_332 graphics) {
        float actualProgress = Math.max(0.0f, Math.min(1.0f, this.getCurrentProgress()));
        this.renderProgress = class_3532.method_15363((float)(this.renderProgress * 0.95f + actualProgress * 0.050000012f), (float)0.0f, (float)1.0f);
        int progressWidth = this.getAbsoluteWidth();
        int progressHeight = this.getAbsoluteHeight();
        int progressX = this.getAbsoluteX();
        int progressY = this.getAbsoluteY();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        class_3532.method_16439((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.direction == BarDirection.LEFT || this.direction == BarDirection.RIGHT) {
            progressWidth = (int)((float)this.getAbsoluteWidth() * this.renderProgress);
        }
        if (this.direction == BarDirection.UP || this.direction == BarDirection.DOWN) {
            progressHeight = (int)((float)this.getAbsoluteHeight() * this.renderProgress);
        }
        if (this.direction == BarDirection.LEFT) {
            progressX += this.getAbsoluteWidth() - progressWidth;
            offsetX = this.getAbsoluteWidth() - progressWidth;
        }
        if (this.direction == BarDirection.UP) {
            progressY += this.getAbsoluteHeight() - progressHeight;
            offsetY = this.getAbsoluteHeight() - progressHeight;
        }
        this.lastProgressX = progressX;
        this.lastProgressY = progressY;
        this.lastProgressWidth = progressWidth;
        this.lastProgressHeight = progressHeight;
        RenderSystem.enableBlend();
        if (this.barTextureSupplier != null) {
            class_2960 loc;
            ITexture t = this.barTextureSupplier.get();
            if (t != null && (loc = t.getResourceLocation()) != null) {
                graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
                graphics.method_25290(loc, progressX, progressY, offsetX, offsetY, progressWidth, progressHeight, this.getAbsoluteWidth(), this.getAbsoluteHeight());
                RenderingUtils.resetShaderColor(graphics);
            }
        } else if (this.barColor != null) {
            RenderingUtils.resetShaderColor(graphics);
            graphics.method_25294(progressX, progressY, progressX + progressWidth, progressY + progressHeight, RenderingUtils.replaceAlphaInColor(this.barColor.getColorInt(), this.opacity));
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    protected void renderBackground(@NotNull class_332 graphics) {
        RenderSystem.enableBlend();
        if (this.backgroundTextureSupplier != null) {
            this.backgroundTextureSupplier.forRenderable((iTexture, location) -> {
                graphics.method_51422(1.0f, 1.0f, 1.0f, this.opacity);
                graphics.method_25290(location, this.getAbsoluteX(), this.getAbsoluteY(), 0.0f, 0.0f, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.getAbsoluteWidth(), this.getAbsoluteHeight());
                RenderingUtils.resetShaderColor(graphics);
            });
        } else if (this.backgroundColor != null) {
            RenderingUtils.resetShaderColor(graphics);
            graphics.method_25294(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteX() + this.getAbsoluteWidth(), this.getAbsoluteY() + this.getAbsoluteHeight(), RenderingUtils.replaceAlphaInColor(this.backgroundColor.getColorInt(), this.opacity));
            RenderingUtils.resetShaderColor(graphics);
        }
    }

    public float getCurrentProgress() {
        String s;
        if (ProgressBarElement.isEditor()) {
            return 0.5f;
        }
        if (this.progressSource != null && MathUtils.isFloat((String)(s = StringUtils.replace((String)PlaceholderParser.replacePlaceholders(this.progressSource), (String)" ", (String)"")))) {
            if (this.progressValueMode == ProgressValueMode.PERCENTAGE) {
                return Float.parseFloat(s) / 100.0f;
            }
            return Float.parseFloat(s);
        }
        return 0.0f;
    }

    @Override
    public int getChildElementAnchorPointX() {
        if (this.useProgressForElementAnchor) {
            if (this.direction == BarDirection.RIGHT) {
                return this.getProgressX() + this.getProgressWidth();
            }
            return this.getProgressX();
        }
        return super.getChildElementAnchorPointX();
    }

    @Override
    public int getChildElementAnchorPointY() {
        if (this.useProgressForElementAnchor) {
            if (this.direction == BarDirection.DOWN) {
                return this.getProgressY() + this.getProgressHeight();
            }
            return this.getProgressY();
        }
        return super.getChildElementAnchorPointY();
    }

    public int getProgressX() {
        return this.lastProgressX;
    }

    public int getProgressY() {
        return this.lastProgressY;
    }

    public int getProgressWidth() {
        return this.lastProgressWidth;
    }

    public int getProgressHeight() {
        return this.lastProgressHeight;
    }

    public static enum BarDirection implements LocalizedCycleEnum<BarDirection>
    {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        private final String name;

        private BarDirection(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.editor.elements.progress_bar.direction";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public BarDirection[] getValues() {
            return BarDirection.values();
        }

        @Override
        @Nullable
        public BarDirection getByNameInternal(@NotNull String name) {
            return BarDirection.getByName(name);
        }

        @Nullable
        public static BarDirection getByName(@NotNull String name) {
            for (BarDirection d : BarDirection.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum ProgressValueMode implements LocalizedCycleEnum<ProgressValueMode>
    {
        PERCENTAGE("percentage"),
        FLOATING_POINT("float");

        private final String name;

        private ProgressValueMode(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.editor.elements.progress_bar.mode";
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public ProgressValueMode[] getValues() {
            return ProgressValueMode.values();
        }

        @Override
        @Nullable
        public ProgressValueMode getByNameInternal(@NotNull String name) {
            return ProgressValueMode.getByName(name);
        }

        @Nullable
        public static ProgressValueMode getByName(@NotNull String name) {
            for (ProgressValueMode d : ProgressValueMode.values()) {
                if (!d.name.equals(name)) continue;
                return d;
            }
            return null;
        }
    }
}

