/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.gui;

import dev.isxander.debugify.client.DebugifyClient;
import dev.isxander.debugify.client.gui.BugFixController;
import dev.isxander.debugify.config.DebugifyConfig;
import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.yacl.api.Binding;
import dev.isxander.yacl.api.ConfigCategory;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionFlag;
import dev.isxander.yacl.api.OptionGroup;
import dev.isxander.yacl.api.YetAnotherConfigLib;
import dev.isxander.yacl.gui.controllers.BooleanController;
import dev.isxander.yacl.gui.controllers.LabelController;
import dev.isxander.yacl.gui.controllers.TickBoxController;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ConfigGuiHelper {
    public static class_437 createConfigGui(DebugifyConfig config, class_437 parent) {
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"debugify.name")).save(config::save);
        Option gameplayWarning = Option.createBuilder(class_2561.class).binding(Binding.immutable((Object)class_2561.method_43471((String)"debugify.gameplay.warning").method_27692(class_124.field_1061))).controller(LabelController::new).build();
        Option gameplayInMultiplayer = Option.createBuilder(Boolean.TYPE).name((class_2561)class_2561.method_43471((String)"debugify.gameplay.enable_in_multiplayer")).binding((Object)false, () -> config.gameplayFixesInMultiplayer, value -> {
            config.gameplayFixesInMultiplayer = value;
        }).controller(TickBoxController::new).build();
        for (BugFix.Env env : BugFix.Env.values()) {
            ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)env.getDisplayName())).tooltip(new class_2561[]{class_2561.method_43471((String)env.getDescriptionKey())});
            for (FixCategory fixCategory : FixCategory.values()) {
                OptionGroup.Builder groupBuilder = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)fixCategory.getDisplayName()));
                if (fixCategory == FixCategory.GAMEPLAY) {
                    groupBuilder.option(gameplayWarning).option(gameplayInMultiplayer);
                }
                config.getBugFixes().forEach((bug, enabled) -> {
                    if (bug.env() == env && bug.category() == fixCategory) {
                        List<String> conflicts = bug.getActiveConflicts().stream().map(id -> ((ModContainer)FabricLoader.getInstance().getModContainer(id).orElseThrow()).getMetadata().getName()).toList();
                        boolean satisfiesOS = bug.satisfiesOSRequirement();
                        boolean unavailable = !conflicts.isEmpty() || !satisfiesOS;
                        Option.Builder optionBuilder = Option.createBuilder(Boolean.TYPE).name((class_2561)class_2561.method_43470((String)bug.bugId())).binding((Object)bug.enabledByDefault(), () -> config.getBugFixes().get(bug), value -> config.getBugFixes().replace((BugFixData)bug, (Boolean)value)).controller(BugFixController::new).available(!unavailable).flag(new OptionFlag[]{OptionFlag.GAME_RESTART});
                        if (DebugifyClient.bugFixDescriptionCache.has(bug.bugId())) {
                            optionBuilder.tooltip(new class_2561[]{class_2561.method_43470((String)DebugifyClient.bugFixDescriptionCache.get(bug.bugId()))});
                        }
                        if (!conflicts.isEmpty()) {
                            optionBuilder.tooltip(new class_2561[]{class_2561.method_43469((String)"debugify.error.conflict", (Object[])new Object[]{bug.bugId(), String.join((CharSequence)", ", conflicts)}).method_27692(class_124.field_1061)});
                        }
                        if (!satisfiesOS) {
                            optionBuilder.tooltip(new class_2561[]{class_2561.method_43469((String)"debugify.error.os", (Object[])new Object[]{bug.bugId(), class_2561.method_43471((String)bug.requiredOs().getDisplayName())}).method_27692(class_124.field_1061)});
                        }
                        groupBuilder.option(optionBuilder.build());
                    }
                });
                categoryBuilder.group(groupBuilder.build());
            }
            yacl.category(categoryBuilder.build());
        }
        yacl.category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"debugify.misc")).option(Option.createBuilder(Boolean.TYPE).name((class_2561)class_2561.method_43471((String)"debugify.misc.default_disabled")).tooltip(new class_2561[]{class_2561.method_43471((String)"debugify.misc.default_disabled.description")}).binding((Object)false, () -> config.defaultDisabled, value -> {
            config.defaultDisabled = value;
        }).controller(BooleanController::new).build()).build());
        return yacl.build().generateScreen(parent);
    }
}

