/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.gui;

import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.AbstractWidget;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.BooleanController;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class BugFixController
extends BooleanController {
    public BugFixController(Option<Boolean> option) {
        super(option, state -> {
            if (!option.available()) {
                return class_2561.method_43471((String)"debugify.fix.unavailable");
            }
            return state != false ? class_2561.method_43471((String)"debugify.fix.enabled").method_27692(class_124.field_1060) : class_2561.method_43471((String)"debugify.fix.disabled").method_27692(class_124.field_1061);
        }, false);
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BugFixControllerElement(this, screen, widgetDimension);
    }

    @Environment(value=EnvType.CLIENT)
    public static class BugFixControllerElement
    extends BooleanController.BooleanControllerElement {
        private String tooltipString;

        public BugFixControllerElement(BugFixController control, YACLScreen screen, Dimension<Integer> dim) {
            super((BooleanController)control, screen, dim);
            control.option().addListener((opt, pending) -> this.recalculateTooltipString());
            this.recalculateTooltipString();
        }

        public boolean matchesSearch(String query) {
            return super.matchesSearch(query) || this.tooltipString.contains(query.toLowerCase());
        }

        private void recalculateTooltipString() {
            this.tooltipString = ((BooleanController)this.control).option().tooltip().getString().toLowerCase();
        }
    }
}

