/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.IntBuffer;
import net.coderbot.iris.mixin.GlStateManagerAccessor;
import org.jetbrains.annotations.Nullable;

public class TextureInfoCache {
    public static final TextureInfoCache INSTANCE = new TextureInfoCache();
    private final Int2ObjectMap<TextureInfo> cache = new Int2ObjectOpenHashMap();

    private TextureInfoCache() {
    }

    public TextureInfo getInfo(int n) {
        TextureInfo textureInfo = (TextureInfo)this.cache.get(n);
        if (textureInfo == null) {
            textureInfo = new TextureInfo(n);
            this.cache.put(n, (Object)textureInfo);
        }
        return textureInfo;
    }

    public void onTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, @Nullable IntBuffer intBuffer) {
        if (n2 == 0) {
            int n9 = GlStateManagerAccessor.getTEXTURES()[GlStateManagerAccessor.getActiveTexture()].field_5167;
            TextureInfo textureInfo = this.getInfo(n9);
            textureInfo.internalFormat = n3;
            textureInfo.width = n4;
            textureInfo.height = n5;
        }
    }

    public void onDeleteTexture(int n) {
        this.cache.remove(n);
    }

    public static class TextureInfo {
        private final int id;
        private int internalFormat = -1;
        private int width = -1;
        private int height = -1;

        private TextureInfo(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public int getInternalFormat() {
            if (this.internalFormat == -1) {
                this.internalFormat = this.fetchLevelParameter(4099);
            }
            return this.internalFormat;
        }

        public int getWidth() {
            if (this.width == -1) {
                this.width = this.fetchLevelParameter(4096);
            }
            return this.width;
        }

        public int getHeight() {
            if (this.height == -1) {
                this.height = this.fetchLevelParameter(4097);
            }
            return this.height;
        }

        private int fetchLevelParameter(int n) {
            int n2 = GlStateManager._getInteger((int)32873);
            GlStateManager._bindTexture((int)this.id);
            int n3 = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)n);
            GlStateManager._bindTexture((int)n2);
            return n3;
        }
    }
}

