/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Optional;
import java.util.Set;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.texture.TextureScaleOverride;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.shaderpack.CloudSetting;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shaderpack.ParticleRenderingSettings;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import org.joml.Vector2i;

public class PackDirectives {
    private int noiseTextureResolution = 256;
    private float sunPathRotation = 0.0f;
    private float ambientOcclusionLevel = 1.0f;
    private float wetnessHalfLife = 600.0f;
    private float drynessHalfLife = 200.0f;
    private float eyeBrightnessHalfLife = 10.0f;
    private float centerDepthHalfLife = 1.0f;
    private CloudSetting cloudSetting;
    private boolean underwaterOverlay;
    private boolean vignette;
    private boolean sun;
    private boolean moon;
    private boolean rainDepth;
    private boolean separateAo;
    private boolean voxelizeLightBlocks;
    private boolean separateEntityDraws;
    private boolean oldLighting;
    private boolean concurrentCompute;
    private boolean oldHandLight;
    private boolean prepareBeforeShadow;
    private Object2ObjectMap<String, Object2BooleanMap<String>> explicitFlips = new Object2ObjectOpenHashMap();
    private Object2ObjectMap<String, TextureScaleOverride> scaleOverrides = new Object2ObjectOpenHashMap();
    private Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap;
    private Int2IntArrayMap bufferObjects = new Int2IntArrayMap();
    private final PackRenderTargetDirectives renderTargetDirectives;
    private final PackShadowDirectives shadowDirectives;
    private Optional<ParticleRenderingSettings> particleRenderingSettings;

    private PackDirectives(Set<Integer> set, PackShadowDirectives packShadowDirectives) {
        this.renderTargetDirectives = new PackRenderTargetDirectives(set);
        this.shadowDirectives = packShadowDirectives;
    }

    PackDirectives(Set<Integer> set, ShaderProperties shaderProperties) {
        this(set, new PackShadowDirectives(shaderProperties));
        this.cloudSetting = shaderProperties.getCloudSetting();
        this.underwaterOverlay = shaderProperties.getUnderwaterOverlay().orElse(false);
        this.vignette = shaderProperties.getVignette().orElse(false);
        this.sun = shaderProperties.getSun().orElse(true);
        this.moon = shaderProperties.getMoon().orElse(true);
        this.rainDepth = shaderProperties.getRainDepth().orElse(false);
        this.separateAo = shaderProperties.getSeparateAo().orElse(false);
        this.voxelizeLightBlocks = shaderProperties.getVoxelizeLightBlocks().orElse(false);
        this.separateEntityDraws = shaderProperties.getSeparateEntityDraws().orElse(false);
        this.oldLighting = shaderProperties.getOldLighting().orElse(false);
        this.concurrentCompute = shaderProperties.getConcurrentCompute().orElse(false);
        this.oldHandLight = shaderProperties.getOldHandLight().orElse(true);
        this.explicitFlips = shaderProperties.getExplicitFlips();
        this.scaleOverrides = shaderProperties.getTextureScaleOverrides();
        this.prepareBeforeShadow = shaderProperties.getPrepareBeforeShadow().orElse(false);
        this.particleRenderingSettings = shaderProperties.getParticleRenderingSettings();
        this.textureMap = shaderProperties.getCustomTexturePatching();
        this.bufferObjects = shaderProperties.getBufferObjects();
    }

    PackDirectives(Set<Integer> set, PackDirectives packDirectives) {
        this(set, new PackShadowDirectives(packDirectives.getShadowDirectives()));
        this.cloudSetting = packDirectives.cloudSetting;
        this.separateAo = packDirectives.separateAo;
        this.voxelizeLightBlocks = packDirectives.voxelizeLightBlocks;
        this.separateEntityDraws = packDirectives.separateEntityDraws;
        this.oldLighting = packDirectives.oldLighting;
        this.concurrentCompute = packDirectives.concurrentCompute;
        this.explicitFlips = packDirectives.explicitFlips;
        this.scaleOverrides = packDirectives.scaleOverrides;
        this.prepareBeforeShadow = packDirectives.prepareBeforeShadow;
        this.particleRenderingSettings = packDirectives.particleRenderingSettings;
        this.textureMap = packDirectives.textureMap;
        this.bufferObjects = packDirectives.bufferObjects;
    }

    public int getNoiseTextureResolution() {
        return this.noiseTextureResolution;
    }

    public float getSunPathRotation() {
        return this.sunPathRotation;
    }

    public float getAmbientOcclusionLevel() {
        return this.ambientOcclusionLevel;
    }

    public float getWetnessHalfLife() {
        return this.wetnessHalfLife;
    }

    public float getDrynessHalfLife() {
        return this.drynessHalfLife;
    }

    public float getEyeBrightnessHalfLife() {
        return this.eyeBrightnessHalfLife;
    }

    public float getCenterDepthHalfLife() {
        return this.centerDepthHalfLife;
    }

    public CloudSetting getCloudSetting() {
        return this.cloudSetting;
    }

    public boolean underwaterOverlay() {
        return this.underwaterOverlay;
    }

    public boolean vignette() {
        return this.vignette;
    }

    public boolean shouldRenderSun() {
        return this.sun;
    }

    public boolean shouldRenderMoon() {
        return this.moon;
    }

    public Optional<ParticleRenderingSettings> getParticleRenderingSettings() {
        return this.particleRenderingSettings;
    }

    public boolean rainDepth() {
        return this.rainDepth;
    }

    public boolean shouldUseSeparateAo() {
        return this.separateAo;
    }

    public boolean shouldVoxelizeLightBlocks() {
        return this.voxelizeLightBlocks;
    }

    public boolean shouldUseSeparateEntityDraws() {
        return this.separateEntityDraws;
    }

    public boolean isOldLighting() {
        return this.oldLighting;
    }

    public boolean isOldHandLight() {
        return this.oldHandLight;
    }

    public boolean getConcurrentCompute() {
        return this.concurrentCompute;
    }

    public boolean isPrepareBeforeShadow() {
        return this.prepareBeforeShadow;
    }

    public Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> getTextureMap() {
        return this.textureMap;
    }

    public PackRenderTargetDirectives getRenderTargetDirectives() {
        return this.renderTargetDirectives;
    }

    public PackShadowDirectives getShadowDirectives() {
        return this.shadowDirectives;
    }

    public Int2IntArrayMap getBufferObjects() {
        return this.bufferObjects;
    }

    private static float clamp(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f3, f));
    }

    public void acceptDirectivesFrom(DirectiveHolder directiveHolder) {
        this.renderTargetDirectives.acceptDirectives(directiveHolder);
        this.shadowDirectives.acceptDirectives(directiveHolder);
        directiveHolder.acceptConstIntDirective("noiseTextureResolution", n -> {
            this.noiseTextureResolution = n;
        });
        directiveHolder.acceptConstFloatDirective("sunPathRotation", f -> {
            this.sunPathRotation = f;
        });
        directiveHolder.acceptConstFloatDirective("ambientOcclusionLevel", f -> {
            this.ambientOcclusionLevel = PackDirectives.clamp(f, 0.0f, 1.0f);
        });
        directiveHolder.acceptConstFloatDirective("wetnessHalflife", f -> {
            this.wetnessHalfLife = f;
        });
        directiveHolder.acceptConstFloatDirective("drynessHalflife", f -> {
            this.wetnessHalfLife = f;
        });
        directiveHolder.acceptConstFloatDirective("eyeBrightnessHalflife", f -> {
            this.eyeBrightnessHalfLife = f;
        });
        directiveHolder.acceptConstFloatDirective("centerDepthHalflife", f -> {
            this.centerDepthHalfLife = f;
        });
    }

    public ImmutableMap<Integer, Boolean> getExplicitFlips(String string) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Object2BooleanMap object2BooleanMap = (Object2BooleanMap)this.explicitFlips.get((Object)string);
        if (object2BooleanMap == null) {
            object2BooleanMap = Object2BooleanMaps.emptyMap();
        }
        object2BooleanMap.forEach((string2, bl) -> {
            int n = PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.indexOf(string2);
            if (n == -1 && string2.startsWith("colortex")) {
                String string3 = string2.substring("colortex".length());
                try {
                    n = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n != -1) {
                builder.put((Object)n, bl);
            } else {
                Iris.logger.warn("Unknown buffer with ID " + string2 + " specified in flip directive for pass " + string);
            }
        });
        return builder.build();
    }

    public Vector2i getTextureScaleOverride(int n, int n2, int n3) {
        String string = "colortex" + n;
        Vector2i vector2i = new Vector2i();
        if (n < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
            String string2 = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(n);
            if (this.scaleOverrides.containsKey((Object)string2)) {
                vector2i.set(((TextureScaleOverride)this.scaleOverrides.get((Object)string2)).getX(n2), ((TextureScaleOverride)this.scaleOverrides.get((Object)string2)).getY(n3));
            } else if (this.scaleOverrides.containsKey((Object)string)) {
                vector2i.set(((TextureScaleOverride)this.scaleOverrides.get((Object)string)).getX(n2), ((TextureScaleOverride)this.scaleOverrides.get((Object)string)).getY(n3));
            } else {
                vector2i.set(n2, n3);
            }
        } else if (this.scaleOverrides.containsKey((Object)string)) {
            vector2i.set(((TextureScaleOverride)this.scaleOverrides.get((Object)string)).getX(n2), ((TextureScaleOverride)this.scaleOverrides.get((Object)string)).getY(n3));
        } else {
            vector2i.set(n2, n3);
        }
        return vector2i;
    }
}

