/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.type.qualifier.StorageQualifier;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.util.Type;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.parameter.SodiumParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;

public class SodiumTransformer {
    public static void transform(ASTParser aSTParser, TranslationUnit translationUnit, Root root, SodiumParameters sodiumParameters) {
        CommonTransformer.transform(aSTParser, translationUnit, root, sodiumParameters, false);
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix0, "mat4(1.0)");
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix1, "iris_LightmapTextureMatrix");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, "uniform mat4 iris_LightmapTextureMatrix;");
        root.rename("gl_ProjectionMatrix", "iris_ProjectionMatrix");
        if (sodiumParameters.type.glShaderType == ShaderType.VERTEX) {
            root.rename("gl_MultiTexCoord2", "gl_MultiTexCoord1");
            if (sodiumParameters.inputs.hasTex()) {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(_vert_tex_diffuse_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(0.0, 0.0, 0.0, 1.0)");
            }
            if (sodiumParameters.inputs.hasLight()) {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(_vert_tex_light_coord, 0.0, 1.0)");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            }
            AttributeTransformer.patchMultiTexCoord3(aSTParser, translationUnit, root, sodiumParameters);
            CommonTransformer.replaceGlMultiTexCoordBounded(aSTParser, root, 4, 7);
        }
        if (sodiumParameters.inputs.hasColor()) {
            root.rename("gl_Color", "_vert_color");
        } else {
            root.replaceReferenceExpressions(aSTParser, "gl_Color", "vec4(1.0)");
        }
        if (sodiumParameters.type.glShaderType == ShaderType.VERTEX) {
            if (sodiumParameters.inputs.hasNormal()) {
                root.rename("gl_Normal", "iris_Normal");
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec3 iris_Normal;");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        root.replaceReferenceExpressions(aSTParser, "gl_NormalMatrix", "iris_NormalMatrix");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat3 iris_NormalMatrix;");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatrixInverse;");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ProjectionMatrixInverse;");
        root.rename("gl_ModelViewMatrix", "iris_ModelViewMatrix");
        root.rename("gl_ModelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        root.rename("gl_ProjectionMatrixInverse", "iris_ProjectionMatrixInverse");
        if (sodiumParameters.type.glShaderType == ShaderType.VERTEX) {
            if (root.identifierIndex.has("ftransform")) {
                translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }"});
            }
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_ProjectionMatrix;", "uniform mat4 iris_ModelViewMatrix;", "uniform vec3 u_RegionOffset;", "vec4 getVertexPosition() { return vec4(u_RegionOffset + Chunks[_draw_id].offset.xyz + _vert_position, 1.0); }"});
            root.replaceReferenceExpressions(aSTParser, "gl_Vertex", "getVertexPosition()");
            SodiumTransformer.injectVertInit(aSTParser, translationUnit, root, sodiumParameters);
        } else {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_ModelViewMatrix;", "uniform mat4 iris_ProjectionMatrix;"});
        }
        root.replaceReferenceExpressions(aSTParser, "gl_ModelViewProjectionMatrix", "(iris_ProjectionMatrix * iris_ModelViewMatrix)");
        CommonTransformer.applyIntelHd4000Workaround(root);
    }

    public static void injectVertInit(ASTParser aSTParser, TranslationUnit translationUnit, Root root, SodiumParameters sodiumParameters) {
        translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec3 _vert_position;", "vec2 _vert_tex_diffuse_coord;", "ivec2 _vert_tex_light_coord;", "vec4 _vert_color;", "uint _draw_id;", "void _vert_init() {_vert_position = (a_PosId.xyz * " + sodiumParameters.positionScale + " + " + sodiumParameters.positionOffset + ");_vert_tex_diffuse_coord = (a_TexCoord * " + sodiumParameters.textureScale + ");_vert_tex_light_coord = a_LightCoord;_vert_color = a_Color;_draw_id = uint(a_PosId.w); }", "struct DrawParameters { vec4 offset; };", "layout(std140) uniform ubo_DrawParameters {DrawParameters Chunks[256]; };"});
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_PosId", Type.F32VEC4, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_TexCoord", Type.F32VEC2, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_Color", Type.F32VEC4, StorageQualifier.StorageType.IN);
        CommonTransformer.addIfNotExists(root, aSTParser, translationUnit, "a_LightCoord", Type.I32VEC2, StorageQualifier.StorageType.IN);
        translationUnit.prependMainFunctionBody(aSTParser, "_vert_init();");
    }
}

