/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.parser.ParseShape;
import java.util.stream.Stream;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.GeometryInfoParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.pipeline.transform.parameter.VanillaParameters;

public class AttributeTransformer {
    private static final AutoHintedMatcher<ExternalDeclaration> uniformVec4EntityColor = new AutoHintedMatcher("uniform vec4 entityColor;", ParseShape.EXTERNAL_DECLARATION);
    private static final AutoHintedMatcher<ExternalDeclaration> uniformIntEntityId = new AutoHintedMatcher("uniform int entityId;", ParseShape.EXTERNAL_DECLARATION);
    private static final AutoHintedMatcher<ExternalDeclaration> uniformIntBlockEntityId = new AutoHintedMatcher("uniform int blockEntityId;", ParseShape.EXTERNAL_DECLARATION);
    private static final AutoHintedMatcher<ExternalDeclaration> uniformIntCurrentRenderedItemId = new AutoHintedMatcher("uniform int currentRenderedItemId;", ParseShape.EXTERNAL_DECLARATION);

    public static void transform(ASTParser aSTParser, TranslationUnit translationUnit, Root root, AttributeParameters attributeParameters) {
        if (translationUnit.getVersionStatement().getNormalizedProfile().isCore()) {
            if (attributeParameters.type == PatchShaderType.VERTEX) {
                throw new IllegalStateException("Vertex shaders must be in the compatibility profile to run properly!");
            }
            return;
        }
        if (attributeParameters.inputs.lightmap) {
            root.rename("gl_MultiTexCoord1", "gl_MultiTexCoord2");
        }
        Stream stream = Stream.empty();
        boolean bl = false;
        if (!attributeParameters.inputs.lightmap) {
            stream = Stream.concat(stream, root.identifierIndex.getStream("gl_MultiTexCoord1"));
            stream = Stream.concat(stream, root.identifierIndex.getStream("gl_MultiTexCoord2"));
            bl = true;
        }
        if (!attributeParameters.inputs.texture) {
            stream = Stream.concat(stream, root.identifierIndex.getStream("gl_MultiTexCoord0"));
            bl = true;
        }
        if (bl) {
            root.replaceReferenceExpressions(aSTParser, stream, "vec4(240.0, 240.0, 0.0, 1.0)");
        }
        AttributeTransformer.patchTextureMatrices(aSTParser, translationUnit, root, attributeParameters.inputs.lightmap);
        if (attributeParameters.inputs.overlay) {
            AttributeTransformer.patchOverlayColor(aSTParser, translationUnit, root, attributeParameters);
        }
        AttributeTransformer.patchMultiTexCoord3(aSTParser, translationUnit, root, attributeParameters);
    }

    public static void patchMultiTexCoord3(ASTParser aSTParser, TranslationUnit translationUnit, Root root, Parameters parameters) {
        if (parameters.type.glShaderType == ShaderType.VERTEX && root.identifierIndex.has("gl_MultiTexCoord3") && !root.identifierIndex.has("mc_midTexCoord")) {
            root.rename("gl_MultiTexCoord3", "mc_midTexCoord");
            translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "attribute vec4 mc_midTexCoord;");
        }
    }

    private static void patchTextureMatrices(ASTParser aSTParser, TranslationUnit translationUnit, Root root, boolean bl) {
        root.rename("gl_TextureMatrix", "iris_TextureMatrix");
        translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"const float iris_ONE_OVER_256 = 0.00390625;", "const float iris_ONE_OVER_32 = iris_ONE_OVER_256 * 8;"});
        if (bl) {
            translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "mat4 iris_LightmapTextureMatrix = gl_TextureMatrix[2];");
        } else {
            translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "mat4 iris_LightmapTextureMatrix =mat4(iris_ONE_OVER_256, 0.0, 0.0, 0.0,     0.0, iris_ONE_OVER_256, 0.0, 0.0,     0.0, 0.0, iris_ONE_OVER_256, 0.0,     iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_32, iris_ONE_OVER_256);");
        }
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "mat4 iris_TextureMatrix[8] = mat4[8](gl_TextureMatrix[0],iris_LightmapTextureMatrix,mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0),mat4(1.0));");
    }

    public static void patchOverlayColor(ASTParser aSTParser, TranslationUnit translationUnit, Root root, GeometryInfoParameters geometryInfoParameters) {
        root.processMatches(aSTParser, uniformVec4EntityColor, ASTNode::detachAndDelete);
        if (geometryInfoParameters.type.glShaderType == ShaderType.VERTEX) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform sampler2D iris_overlay;", "out vec4 entityColor;", "out vec4 iris_vertexColor;", "in ivec2 iris_UV1;"});
            translationUnit.prependMainFunctionBody(aSTParser, new String[]{"vec4 overlayColor = texelFetch(iris_overlay, iris_UV1, 0);", "entityColor = vec4(overlayColor.rgb, 1.0 - overlayColor.a);", "iris_vertexColor = iris_Color;", "entityColor.rgb *= float(entityColor.a != 0.0);"});
        } else if (geometryInfoParameters.type.glShaderType == ShaderType.GEOMETRY) {
            root.replaceReferenceExpressions(aSTParser, "entityColor", "entityColor[0]");
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"out vec4 entityColorGS;", "in vec4 entityColor[];", "out vec4 iris_vertexColorGS;", "in vec4 iris_vertexColor[];"});
            translationUnit.prependMainFunctionBody(aSTParser, new String[]{"entityColorGS = entityColor[0];", "iris_vertexColorGS = iris_vertexColor[0];"});
        } else if (geometryInfoParameters.type.glShaderType == ShaderType.FRAGMENT) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"in vec4 entityColor;", "in vec4 iris_vertexColor;"});
            translationUnit.prependMainFunctionBody(aSTParser, "float iris_vertexColorAlpha = iris_vertexColor.a;");
            if (geometryInfoParameters.hasGeometry) {
                root.rename("entityColor", "entityColorGS");
                root.rename("iris_vertexColor", "iris_vertexColorGS");
            }
        }
    }

    public static void patchEntityId(ASTParser aSTParser, TranslationUnit translationUnit, Root root, VanillaParameters vanillaParameters) {
        root.processMatches(aSTParser, uniformIntEntityId, ASTNode::detachAndDelete);
        root.processMatches(aSTParser, uniformIntBlockEntityId, ASTNode::detachAndDelete);
        root.processMatches(aSTParser, uniformIntCurrentRenderedItemId, ASTNode::detachAndDelete);
        if (vanillaParameters.type.glShaderType == ShaderType.GEOMETRY) {
            root.replaceReferenceExpressions(aSTParser, "entityId", "iris_entityInfo[0].x");
            root.replaceReferenceExpressions(aSTParser, "blockEntityId", "iris_entityInfo[0].y");
            root.replaceReferenceExpressions(aSTParser, "currentRenderedItemId", "iris_entityInfo[0].z");
        } else {
            root.replaceReferenceExpressions(aSTParser, "entityId", "iris_entityInfo.x");
            root.replaceReferenceExpressions(aSTParser, "blockEntityId", "iris_entityInfo.y");
            root.replaceReferenceExpressions(aSTParser, "currentRenderedItemId", "iris_entityInfo.z");
        }
        if (vanillaParameters.type.glShaderType == ShaderType.VERTEX) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"flat out ivec3 iris_entityInfo;", "in ivec3 iris_Entity;"});
            translationUnit.prependMainFunctionBody(aSTParser, "iris_entityInfo = iris_Entity;");
        } else if (vanillaParameters.type.glShaderType == ShaderType.GEOMETRY) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"flat out ivec3 iris_entityInfoGS;", "flat in ivec3 iris_entityInfo[];"});
            translationUnit.prependMainFunctionBody(aSTParser, "iris_entityInfoGS = iris_entityInfo[0];");
        } else if (vanillaParameters.type.glShaderType == ShaderType.FRAGMENT) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"flat in ivec3 iris_entityInfo;"});
            if (vanillaParameters.hasGeometry) {
                root.rename("iris_entityInfo", "iris_EntityInfoGS");
            }
        }
    }
}

