/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import io.github.douira.glsl_transformer.ast.node.Profile;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.VersionStatement;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.query.index.PrefixIdentifierIndex;
import io.github.douira.glsl_transformer.ast.transform.EnumASTTransformer;
import io.github.douira.glsl_transformer.token_filter.ChannelFilter;
import io.github.douira.glsl_transformer.token_filter.TokenChannel;
import io.github.douira.glsl_transformer.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.util.LRUCache;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.texture.TextureType;
import net.coderbot.iris.helpers.Tri;
import net.coderbot.iris.pipeline.PatchedShaderPrinter;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.Patch;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.AttributeParameters;
import net.coderbot.iris.pipeline.transform.parameter.ComputeParameters;
import net.coderbot.iris.pipeline.transform.parameter.Parameters;
import net.coderbot.iris.pipeline.transform.parameter.SodiumParameters;
import net.coderbot.iris.pipeline.transform.parameter.TextureStageParameters;
import net.coderbot.iris.pipeline.transform.parameter.VanillaParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompatibilityTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompositeCoreTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CompositeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.SodiumCoreTransformer;
import net.coderbot.iris.pipeline.transform.transformer.SodiumTransformer;
import net.coderbot.iris.pipeline.transform.transformer.TextureTransformer;
import net.coderbot.iris.pipeline.transform.transformer.VanillaCoreTransformer;
import net.coderbot.iris.pipeline.transform.transformer.VanillaTransformer;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import org.antlr.v4.runtime.Token;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransformPatcher {
    static Logger LOGGER = LogManager.getLogger(TransformPatcher.class);
    private static EnumASTTransformer<Parameters, PatchShaderType> transformer;
    private static final boolean useCache = true;
    private static final Map<CacheKey, Map<PatchShaderType, String>> cache;
    static TokenFilter<Parameters> parseTokenFilter;
    private static final List<String> internalPrefixes;
    private static final Pattern versionPattern;

    private static Map<PatchShaderType, String> transform(String string, String string2, String string3, Parameters parameters) {
        if (string == null && string2 == null && string3 == null) {
            return null;
        }
        Map map = null;
        CacheKey cacheKey = new CacheKey(parameters, string, string2, string3);
        if (cache.containsKey(cacheKey)) {
            map = cache.get(cacheKey);
        }
        if (map == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> enumMap = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            enumMap.put(PatchShaderType.VERTEX, string);
            enumMap.put(PatchShaderType.GEOMETRY, string2);
            enumMap.put(PatchShaderType.FRAGMENT, string3);
            map = (Map)transformer.transform(enumMap, (Object)parameters);
            cache.put(cacheKey, map);
        }
        return map;
    }

    private static Map<PatchShaderType, String> transformCompute(String string, Parameters parameters) {
        if (string == null) {
            return null;
        }
        Map map = null;
        CacheKey cacheKey = new CacheKey(parameters, string);
        if (cache.containsKey(cacheKey)) {
            map = cache.get(cacheKey);
        }
        if (map == null) {
            transformer.setPrintType(PatchedShaderPrinter.prettyPrintShaders ? PrintType.INDENTED : PrintType.SIMPLE);
            EnumMap<PatchShaderType, String> enumMap = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
            enumMap.put(PatchShaderType.COMPUTE, string);
            map = (Map)transformer.transform(enumMap, (Object)parameters);
            cache.put(cacheKey, map);
        }
        return map;
    }

    public static Map<PatchShaderType, String> patchAttributes(String string, String string2, String string3, InputAvailability inputAvailability, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new AttributeParameters(Patch.ATTRIBUTES, object2ObjectMap, string2 != null, inputAvailability));
    }

    public static Map<PatchShaderType, String> patchVanilla(String string, String string2, String string3, AlphaTest alphaTest, boolean bl, boolean bl2, ShaderAttributeInputs shaderAttributeInputs, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new VanillaParameters(Patch.VANILLA, object2ObjectMap, alphaTest, bl, bl2, shaderAttributeInputs, string2 != null));
    }

    public static Map<PatchShaderType, String> patchSodium(String string, String string2, String string3, AlphaTest alphaTest, ShaderAttributeInputs shaderAttributeInputs, float f, float f2, float f3, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new SodiumParameters(Patch.SODIUM, object2ObjectMap, alphaTest, shaderAttributeInputs, f, f2, f3));
    }

    public static Map<PatchShaderType, String> patchComposite(String string, String string2, String string3, TextureStage textureStage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transform(string, string2, string3, new TextureStageParameters(Patch.COMPOSITE, textureStage, object2ObjectMap));
    }

    public static String patchCompute(String string, TextureStage textureStage, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> object2ObjectMap) {
        return TransformPatcher.transformCompute(string, new ComputeParameters(Patch.COMPUTE, textureStage, object2ObjectMap)).getOrDefault((Object)PatchShaderType.COMPUTE, null);
    }

    static {
        cache = new LRUCache(400);
        class Net_coderbot_iris_pipeline_transform_TransformPatcher$1
        extends ChannelFilter<Parameters> {
            Net_coderbot_iris_pipeline_transform_TransformPatcher$1(TokenChannel tokenChannel) {
                super(tokenChannel);
            }

            public boolean isTokenAllowed(Token token) {
                if (!super.isTokenAllowed(token)) {
                    throw new IllegalArgumentException("Unparsed preprocessor directives such as '" + token.getText() + "' may not be present at this stage of shader processing!");
                }
                return true;
            }
        }
        parseTokenFilter = new Net_coderbot_iris_pipeline_transform_TransformPatcher$1(TokenChannel.PREPROCESSOR);
        internalPrefixes = List.of("iris_", "irisMain", "moj_import");
        class Net_coderbot_iris_pipeline_transform_TransformPatcher$2
        extends EnumASTTransformer<Parameters, PatchShaderType> {
            Net_coderbot_iris_pipeline_transform_TransformPatcher$2(Class clazz) {
                super(clazz);
                this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
            }

            public TranslationUnit parseTranslationUnit(Root root, String string) {
                Matcher matcher = versionPattern.matcher(string);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
                }
                Version version = Version.fromNumber((int)Integer.parseInt(matcher.group(1)));
                if (version.number >= 200) {
                    version = Version.GLSL33;
                }
                TransformPatcher.transformer.getLexer().version = version;
                return super.parseTranslationUnit(root, string);
            }
        }
        transformer = new Net_coderbot_iris_pipeline_transform_TransformPatcher$2(PatchShaderType.class);
        transformer.setTransformation((enumMap, parameters) -> {
            for (PatchShaderType patchShaderType : PatchShaderType.values()) {
                TranslationUnit translationUnit = (TranslationUnit)enumMap.get((Object)patchShaderType);
                if (translationUnit == null) continue;
                translationUnit.outputOptions.enablePrintInfo();
                parameters.type = patchShaderType;
                Root root = translationUnit.getRoot();
                internalPrefixes.stream().flatMap(arg_0 -> ((PrefixIdentifierIndex)root.getPrefixIdentifierIndex()).prefixQueryFlat(arg_0)).findAny().ifPresent(identifier -> {
                    throw new IllegalArgumentException("Detected a potential reference to unstable and internal Iris shader interfaces (iris_, irisMain and moj_import). This isn't currently supported. Violation: " + identifier.getName() + ". See debugging.md for more information.");
                });
                root.indexBuildSession(() -> {
                    VersionStatement versionStatement = translationUnit.getVersionStatement();
                    if (versionStatement == null) {
                        throw new IllegalStateException("Missing the version statement!");
                    }
                    Profile profile = versionStatement.profile;
                    Version version = versionStatement.version;
                    block0 : switch (parameters.patch) {
                        case ATTRIBUTES: {
                            AttributeTransformer.transform(transformer, translationUnit, root, (AttributeParameters)parameters);
                            break;
                        }
                        case COMPUTE: {
                            versionStatement.profile = Profile.CORE;
                            CommonTransformer.transform(transformer, translationUnit, root, parameters, true);
                            break;
                        }
                        default: {
                            boolean bl;
                            boolean bl2 = bl = parameters.patch == Patch.VANILLA && ((VanillaParameters)parameters).isLines();
                            if (profile == Profile.CORE || version.number >= 150 && profile == null || bl) {
                                if (version.number < 330) {
                                    versionStatement.version = Version.GLSL33;
                                }
                                switch (parameters.patch) {
                                    case COMPOSITE: {
                                        CompositeCoreTransformer.transform(transformer, translationUnit, root, parameters);
                                        break;
                                    }
                                    case SODIUM: {
                                        SodiumParameters sodiumParameters = (SodiumParameters)parameters;
                                        SodiumCoreTransformer.transform(transformer, translationUnit, root, sodiumParameters);
                                        break;
                                    }
                                    case VANILLA: {
                                        VanillaCoreTransformer.transform(transformer, translationUnit, root, (VanillaParameters)parameters);
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException("Unknown patch type: " + parameters.patch);
                                    }
                                }
                                if (parameters.type != PatchShaderType.FRAGMENT) break;
                                CompatibilityTransformer.transformFragmentCore(transformer, translationUnit, root, parameters);
                                break;
                            }
                            if (version.number < 330) {
                                versionStatement.version = Version.GLSL33;
                            }
                            versionStatement.profile = Profile.CORE;
                            switch (parameters.patch) {
                                case COMPOSITE: {
                                    CompositeTransformer.transform(transformer, translationUnit, root, parameters);
                                    break block0;
                                }
                                case SODIUM: {
                                    SodiumParameters sodiumParameters = (SodiumParameters)parameters;
                                    SodiumTransformer.transform(transformer, translationUnit, root, sodiumParameters);
                                    break block0;
                                }
                                case VANILLA: {
                                    VanillaTransformer.transform(transformer, translationUnit, root, (VanillaParameters)parameters);
                                    break block0;
                                }
                            }
                            throw new UnsupportedOperationException("Unknown patch type: " + parameters.patch);
                        }
                    }
                    TextureTransformer.transform(transformer, translationUnit, root, parameters.getTextureStage(), parameters.getTextureMap());
                    CompatibilityTransformer.transformEach(transformer, translationUnit, root, parameters);
                });
            }
            CompatibilityTransformer.transformGrouped(transformer, enumMap, parameters);
        });
        transformer.setTokenFilter(parseTokenFilter);
        versionPattern = Pattern.compile("^.*#version\\s+(\\d+)", 32);
    }

    private static class CacheKey {
        final Parameters parameters;
        final String vertex;
        final String geometry;
        final String fragment;
        final String compute;

        public CacheKey(Parameters parameters, String string, String string2, String string3) {
            this.parameters = parameters;
            this.vertex = string;
            this.geometry = string2;
            this.fragment = string3;
            this.compute = null;
        }

        public CacheKey(Parameters parameters, String string) {
            this.parameters = parameters;
            this.vertex = null;
            this.geometry = null;
            this.fragment = null;
            this.compute = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.parameters == null ? 0 : this.parameters.hashCode());
            n = 31 * n + (this.vertex == null ? 0 : this.vertex.hashCode());
            n = 31 * n + (this.geometry == null ? 0 : this.geometry.hashCode());
            n = 31 * n + (this.fragment == null ? 0 : this.fragment.hashCode());
            n = 31 * n + (this.compute == null ? 0 : this.compute.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)object;
            if (this.parameters == null ? cacheKey.parameters != null : !this.parameters.equals(cacheKey.parameters)) {
                return false;
            }
            if (this.vertex == null ? cacheKey.vertex != null : !this.vertex.equals(cacheKey.vertex)) {
                return false;
            }
            if (this.geometry == null ? cacheKey.geometry != null : !this.geometry.equals(cacheKey.geometry)) {
                return false;
            }
            if (this.fragment == null ? cacheKey.fragment != null : !this.fragment.equals(cacheKey.fragment)) {
                return false;
            }
            return !(this.compute == null ? cacheKey.compute != null : !this.compute.equals(cacheKey.compute));
        }
    }
}

