/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform;

import net.coderbot.iris.gl.shader.ShaderType;

public enum PatchShaderType {
    VERTEX(ShaderType.VERTEX),
    GEOMETRY(ShaderType.GEOMETRY),
    FRAGMENT(ShaderType.FRAGMENT),
    COMPUTE(ShaderType.COMPUTE);

    public final ShaderType glShaderType;

    private PatchShaderType(ShaderType shaderType) {
        this.glShaderType = shaderType;
    }

    public static PatchShaderType[] fromGlShaderType(ShaderType shaderType) {
        switch (shaderType) {
            case VERTEX: {
                return new PatchShaderType[]{VERTEX};
            }
            case GEOMETRY: {
                return new PatchShaderType[]{GEOMETRY};
            }
            case COMPUTE: {
                return new PatchShaderType[]{COMPUTE};
            }
            case FRAGMENT: {
                return new PatchShaderType[]{FRAGMENT};
            }
        }
        throw new IllegalArgumentException("Unknown shader type: " + shaderType);
    }
}

