/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.entries.ChildEntry;
import com.terraformersmc.modmenu.gui.widget.entries.IndependentEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.gui.widget.entries.ParentEntry;
import com.terraformersmc.modmenu.util.mod.Mod;
import com.terraformersmc.modmenu.util.mod.ModSearch;
import com.terraformersmc.modmenu.util.mod.fabric.FabricIconHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class ModListWidget
extends class_4280<ModListEntry>
implements AutoCloseable {
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final ModsScreen parent;
    private List<Mod> mods = null;
    private final Set<Mod> addedMods = new HashSet<Mod>();
    private String selectedModId = null;
    private boolean scrolling;
    private final FabricIconHandler iconHandler = new FabricIconHandler();

    public ModListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.mods = list.mods;
        }
        this.filter(searchTerm, false);
        this.method_25307(parent.getScrollPercent() * (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
    }

    public void method_25307(double amount) {
        super.method_25307(amount);
        int denominator = Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.method_25341() / (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
        }
    }

    public boolean method_25370() {
        return this.parent.method_25399() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            Mod mod = entry.getMod();
            this.field_22740.method_44713().method_19788(class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{mod.getTranslatedName()}).getString());
        }
    }

    public void setSelected(ModListEntry entry) {
        super.method_25313((class_350.class_351)entry);
        this.selectedModId = entry.getMod().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.method_25334());
    }

    protected boolean method_25332(int index) {
        ModListEntry selected = (ModListEntry)this.method_25334();
        return selected != null && selected.getMod().getId().equals(((ModListEntry)this.method_25326(index)).getMod().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.mod)) {
            return 0;
        }
        this.addedMods.add(entry.mod);
        int i = super.method_25321((class_350.class_351)entry);
        if (entry.getMod().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.mod);
        return super.method_25330((class_350.class_351)entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)this.method_25326((int)index)).mod);
        return (ModListEntry)super.method_25338(index);
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.method_25339();
        this.addedMods.clear();
        ArrayList mods = (ArrayList)((Object)ModMenu.MODS.values().stream().filter(mod -> {
            Map<String, Boolean> modHasConfigScreen;
            Boolean hasConfig;
            if (ModMenuConfig.CONFIG_MODE.getValue() && !(hasConfig = (modHasConfigScreen = this.parent.getModHasConfigScreen()).get(mod.getId())).booleanValue()) {
                return false;
            }
            return !ModMenuConfig.HIDDEN_MODS.getValue().contains(mod.getId());
        }).collect(Collectors.toSet()));
        if (DEBUG) {
            mods = new ArrayList(mods);
        }
        if (this.mods == null || refresh) {
            this.mods = new ArrayList<Mod>();
            this.mods.addAll(mods);
            this.mods.sort(ModMenuConfig.SORTING.getValue().getComparator());
        }
        List<Mod> matched = ModSearch.search(this.parent, searchTerm, this.mods);
        for (Mod mod2 : matched) {
            String modId = mod2.getId();
            if (mod2.getBadges().contains((Object)Mod.Badge.LIBRARY) && !ModMenuConfig.SHOW_LIBRARIES.getValue() || ModMenu.PARENT_MAP.values().contains(mod2)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(mod2)) {
                List children = ModMenu.PARENT_MAP.get((Object)mod2);
                children.sort(ModMenuConfig.SORTING.getValue().getComparator());
                ParentEntry parent = new ParentEntry(mod2, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<Mod> validChildren = ModSearch.search(this.parent, searchTerm, children);
                for (Mod child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(mod2, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.method_25396().isEmpty() || this.method_25334() != null && ((ModListEntry)this.method_25334()).getMod() != this.parent.getSelectedEntry().getMod()) {
            for (ModListEntry entry : this.method_25396()) {
                if (!entry.getMod().equals(this.parent.getSelectedEntry().getMod())) continue;
                this.setSelected(entry);
            }
        } else if (this.method_25334() == null && !this.method_25396().isEmpty() && this.method_25326(0) != null) {
            this.setSelected((ModListEntry)this.method_25326(0));
        }
        if (this.method_25341() > (double)Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4))) {
            this.method_25307(Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)));
        }
    }

    protected void method_25311(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int entryCount = this.method_25340();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        for (int index = 0; index < entryCount; ++index) {
            int entryLeft;
            int entryTop = this.method_25337(index) + 2;
            int entryBottom = this.method_25337(index) + this.field_22741;
            if (entryBottom < this.field_19085 || entryTop > this.field_19086) continue;
            int entryHeight = this.field_22741 - 4;
            ModListEntry entry = (ModListEntry)this.method_25326(index);
            int rowWidth = this.method_25322();
            if (this.method_25332(index)) {
                entryLeft = this.method_25342() - 2 + entry.getXOffset();
                int selectionRight = this.method_25342() + rowWidth + 2;
                float float_2 = this.method_25370() ? 1.0f : 0.5f;
                RenderSystem.setShader(class_757::method_34539);
                RenderSystem.setShaderColor((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                Matrix4f matrix = matrices.method_23760().method_23761();
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                buffer.method_22918(matrix, (float)entryLeft, (float)(entryTop + entryHeight + 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)selectionRight, (float)(entryTop + entryHeight + 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)selectionRight, (float)(entryTop - 2), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)entryLeft, (float)(entryTop - 2), 0.0f).method_1344();
                tessellator.method_1350();
                RenderSystem.setShader(class_757::method_34539);
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                buffer.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop + entryHeight + 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop + entryHeight + 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(selectionRight - 1), (float)(entryTop - 1), 0.0f).method_1344();
                buffer.method_22918(matrix, (float)(entryLeft + 1), (float)(entryTop - 1), 0.0f).method_1344();
                tessellator.method_1350();
            }
            entryLeft = this.method_25342();
            entry.method_25343(matrices, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.method_25405(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    public void ensureVisible(ModListEntry entry) {
        super.method_25328((class_350.class_351)entry);
    }

    protected void method_25318(double double_1, double double_2, int int_1) {
        super.method_25318(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.method_25329() && double_1 < (double)(this.method_25329() + 6);
    }

    public boolean method_25402(double double_1, double double_2, int int_1) {
        this.method_25318(double_1, double_2, int_1);
        if (!this.method_25405(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.method_25402(double_1, double_2, int_1)) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.method_25310((int)(double_1 - (double)(this.field_19088 + this.field_22742 / 2 - this.method_25322() / 2)), (int)(double_2 - (double)this.field_19085) + (int)this.method_25341() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265 || keyCode == 264) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.method_25334() != null) {
            return ((ModListEntry)this.method_25334()).method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.field_22748 + (int)this.method_25341() - 4;
        int index = int_5 / this.field_22741;
        return x < (double)this.method_25329() && x >= (double)this.method_25342() && x <= (double)(this.method_25342() + this.method_25322()) && index >= 0 && int_5 >= 0 && index < this.method_25340() ? (ModListEntry)((Object)this.method_25396().get(index)) : null;
    }

    protected int method_25329() {
        return this.field_22742 - 6;
    }

    public int method_25322() {
        return this.field_22742 - (Math.max(0, this.method_25317() - (this.field_19086 - this.field_19085 - 4)) > 0 ? 18 : 12);
    }

    public int method_25342() {
        return this.field_19088 + 6;
    }

    public int getWidth() {
        return this.field_22742;
    }

    public int getTop() {
        return this.field_19085;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int method_25317() {
        return super.method_25317() + 4;
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.method_25396()) {
            if (!set.contains(c.getMod().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        this.iconHandler.close();
    }

    public FabricIconHandler getFabricIconHandler() {
        return this.iconHandler;
    }
}

