/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl.api.Binding;
import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionFlag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public final class OptionImpl<T>
implements Option<T> {
    private final class_2561 name;
    private class_2561 tooltip;
    private final Controller<T> controller;
    private final Binding<T> binding;
    private boolean available;
    private final ImmutableSet<OptionFlag> flags;
    private final Class<T> typeClass;
    private T pendingValue;
    private final List<BiConsumer<Option<T>, T>> listeners;

    public OptionImpl(@NotNull class_2561 name, @Nullable Function<T, class_2561> tooltipGetter, @NotNull Function<Option<T>, Controller<T>> controlGetter, @NotNull Binding<T> binding, boolean available, ImmutableSet<OptionFlag> flags, @NotNull Class<T> typeClass, @NotNull Collection<BiConsumer<Option<T>, T>> listeners) {
        this.name = name;
        this.binding = binding;
        this.available = available;
        this.flags = flags;
        this.typeClass = typeClass;
        this.listeners = new ArrayList<BiConsumer<Option<T>, T>>(listeners);
        this.controller = controlGetter.apply(this);
        this.addListener((opt, pending) -> {
            this.tooltip = (class_2561)tooltipGetter.apply(pending);
        });
        this.requestSet(this.binding().getValue());
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public Controller<T> controller() {
        return this.controller;
    }

    @Override
    @NotNull
    public Binding<T> binding() {
        return this.binding;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    @NotNull
    public Class<T> typeClass() {
        return this.typeClass;
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    public boolean changed() {
        return !this.binding().getValue().equals(this.pendingValue);
    }

    @Override
    @NotNull
    public T pendingValue() {
        return this.pendingValue;
    }

    @Override
    public void requestSet(T value) {
        this.pendingValue = value;
        this.listeners.forEach(listener -> listener.accept(this, this.pendingValue));
    }

    @Override
    public boolean applyValue() {
        if (this.changed()) {
            this.binding().setValue(this.pendingValue);
            return true;
        }
        return false;
    }

    @Override
    public void forgetPendingValue() {
        this.requestSet(this.binding().getValue());
    }

    @Override
    public void requestSetDefault() {
        this.requestSet(this.binding().defaultValue());
    }

    @Override
    public boolean isPendingValueDefault() {
        return this.binding().defaultValue().equals(this.pendingValue());
    }

    @Override
    public void addListener(BiConsumer<Option<T>, T> changedListener) {
        this.listeners.add(changedListener);
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.Internal
    public static class BuilderImpl<T>
    implements Option.Builder<T> {
        private class_2561 name = class_2561.method_43470((String)"Name not specified!").method_27692(class_124.field_1061);
        private final List<Function<T, class_2561>> tooltipGetters = new ArrayList<Function<T, class_2561>>();
        private Function<Option<T>, Controller<T>> controlGetter;
        private Binding<T> binding;
        private boolean available = true;
        private boolean instant = false;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private final Class<T> typeClass;
        private final List<BiConsumer<Option<T>, T>> listeners = new ArrayList<BiConsumer<Option<T>, T>>();

        public BuilderImpl(Class<T> typeClass) {
            this.typeClass = typeClass;
        }

        @Override
        public Option.Builder<T> name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        @SafeVarargs
        public final Option.Builder<T> tooltip(Function<T, class_2561> ... tooltipGetter) {
            Validate.notNull(tooltipGetter, (String)"`tooltipGetter` cannot be null", (Object[])new Object[0]);
            this.tooltipGetters.addAll(List.of(tooltipGetter));
            return this;
        }

        @Override
        public Option.Builder<T> tooltip(class_2561 ... tooltips) {
            Validate.notNull((Object)tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipGetters.addAll(Stream.of(tooltips).map(Component -> t -> Component).toList());
            return this;
        }

        @Override
        public Option.Builder<T> controller(@NotNull Function<Option<T>, Controller<T>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controlGetter = control;
            return this;
        }

        @Override
        public Option.Builder<T> binding(@NotNull Binding<T> binding) {
            Validate.notNull(binding, (String)"`binding` cannot be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        @Override
        public Option.Builder<T> binding(@NotNull T def, @NotNull @NotNull Supplier<@NotNull T> getter, @NotNull @NotNull Consumer<@NotNull T> setter) {
            Validate.notNull(def, (String)"`def` must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"`getter` must not be null", (Object[])new Object[0]);
            Validate.notNull(setter, (String)"`setter` must not be null", (Object[])new Object[0]);
            this.binding = Binding.generic(def, getter, setter);
            return this;
        }

        @Override
        public Option.Builder<T> available(boolean available) {
            this.available = available;
            return this;
        }

        @Override
        public Option.Builder<T> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        @Override
        public Option.Builder<T> flags(@NotNull Collection<OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        @Override
        public Option.Builder<T> instant(boolean instant) {
            this.instant = instant;
            return this;
        }

        @Override
        public Option.Builder<T> listener(@NotNull BiConsumer<Option<T>, T> listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public Option.Builder<T> listeners(@NotNull Collection<BiConsumer<Option<T>, T>> listeners) {
            this.listeners.addAll(listeners);
            return this;
        }

        @Override
        public Option<T> build() {
            Validate.notNull(this.controlGetter, (String)"`control` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"`binding` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.isTrue((!this.instant || this.flags.isEmpty() ? 1 : 0) != 0, (String)"instant application does not support option flags", (Object[])new Object[0]);
            Function<Object, class_2561> concatenatedTooltipGetter = value -> {
                class_5250 concatenatedTooltip = class_2561.method_43473();
                boolean first = true;
                for (Function<Object, class_2561> function : this.tooltipGetters) {
                    if (!first) {
                        concatenatedTooltip.method_27693("\n");
                    }
                    first = false;
                    concatenatedTooltip.method_10852(function.apply(value));
                }
                return concatenatedTooltip;
            };
            if (this.instant) {
                this.listeners.add((opt, pendingValue) -> opt.applyValue());
            }
            return new OptionImpl<Object>(this.name, concatenatedTooltipGetter, this.controlGetter, this.binding, this.available, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.typeClass, this.listeners);
        }
    }
}

