/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix.fabric;

import ca.fxco.memoryleakfix.MemoryLeakFix;
import ca.fxco.memoryleakfix.MemoryLeakFixExpectPlatform;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2540;
import org.spongepowered.asm.logging.LoggerAdapterDefault;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MemoryLeakFixFabric
implements ModInitializer {
    public static final Set<class_2540> BUFFERS_TO_CLEAR = Collections.synchronizedSet(new HashSet());
    private static final String OBJECT = "java/lang/Object";

    public void onInitialize() {
        MemoryLeakFix.init();
    }

    public static void forceLoadAllMixinsAndClearSpongePoweredCache() {
        try {
            if (Version.parse((String)"0.14.14").compareTo((Object)Version.parse((String)"0.14.15")) < 0) {
                MemoryLeakFixFabric.internalForceLoadAllMixinsAndClearSpongePoweredCache();
            }
        }
        catch (VersionParsingException versionParsingException) {
            // empty catch block
        }
    }

    private static void internalForceLoadAllMixinsAndClearSpongePoweredCache() throws VersionParsingException {
        MemoryLeakFix.LOGGER.info("[MemoryLeakFix] Attempting to ForceLoad All Mixins and clear cache");
        MemoryLeakFixFabric.silenceAuditLogger();
        MixinEnvironment.getCurrentEnvironment().audit();
        try {
            Field noGroupField = InjectorGroupInfo.Map.class.getDeclaredField("NO_GROUP");
            noGroupField.setAccessible(true);
            Object noGroup = noGroupField.get(null);
            Field membersField = noGroup.getClass().getDeclaredField("members");
            membersField.setAccessible(true);
            ((List)membersField.get(noGroup)).clear();
            MemoryLeakFixFabric.emptyClassInfo();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        MemoryLeakFix.LOGGER.info("[MemoryLeakFix] Done ForceLoad and clearing SpongePowered cache");
    }

    private static Class<?> getMixinLoggerClass() throws ClassNotFoundException {
        Class<?> mixinLogger;
        try {
            mixinLogger = Class.forName("net.fabricmc.loader.impl.launch.knot.MixinLogger");
        }
        catch (ClassNotFoundException err) {
            mixinLogger = Class.forName("org.quiltmc.loader.impl.launch.knot.MixinLogger");
        }
        return mixinLogger;
    }

    private static void silenceAuditLogger() {
        try {
            Field loggerField = MemoryLeakFixFabric.getMixinLoggerClass().getDeclaredField("LOGGER_MAP");
            loggerField.setAccessible(true);
            Map loggerMap = (Map)loggerField.get(null);
            loggerMap.put("mixin.audit", new LoggerAdapterDefault("mixin.audit"));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    private static void emptyClassInfo() throws NoSuchFieldException, IllegalAccessException {
        if (MemoryLeakFixExpectPlatform.isModLoaded("not-that-cc")) {
            return;
        }
        Field cacheField = ClassInfo.class.getDeclaredField("cache");
        cacheField.setAccessible(true);
        Map cache = (Map)cacheField.get(null);
        ClassInfo jlo = (ClassInfo)cache.get(OBJECT);
        cache.clear();
        cache.put(OBJECT, jlo);
    }
}

