/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.cloth;

import ca.fxco.moreculling.config.cloth.AbstractDynamicBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDynamicEntry<T>
extends TooltipListEntry<T> {
    protected class_339 mainWidget;
    protected class_4185 resetButton;
    @Nullable
    private final Consumer<T> saveConsumer;
    @Nullable
    private final BiConsumer<AbstractDynamicEntry<T>, T> changeConsumer;
    private final T original;
    private final AtomicReference<T> value;
    private final Supplier<T> defaultValue;
    private final List<class_339> widgets;
    private boolean enabled;
    private final boolean locked;

    public AbstractDynamicEntry(AbstractDynamicBuilder<T, AbstractConfigListEntry<T>, ?> builder) {
        this(builder.getFieldNameKey(), builder.getResetButtonKey(), builder.getValue(), builder.getDefaultValue(), builder.saveConsumer, builder.changeConsumer, null, builder.isRequireRestart(), builder.getLocked());
    }

    public AbstractDynamicEntry(class_2561 fieldName, class_2561 resetButtonKey, T value, Supplier<T> defaultValue, @Nullable Consumer<T> saveConsumer, @Nullable BiConsumer<AbstractDynamicEntry<T>, T> changeConsumer, Supplier<Optional<class_2561[]>> tooltipSupplier, boolean requiresRestart, boolean locked) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.original = value;
        this.locked = locked;
        this.enabled = !locked;
        this.value = new AtomicReference<T>(value);
        this.changeConsumer = changeConsumer;
        this.saveConsumer = saveConsumer;
        this.mainWidget = this.createMainWidget();
        this.resetButton = class_4185.method_46430((class_2561)resetButtonKey, widget -> {
            if (this.getDefaultValue().isPresent() && !this.getValue().equals(this.getDefaultValue().get())) {
                this.setValue(this.getDefaultValue().get());
                this.onChange();
            }
        }).method_46434(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)resetButtonKey) + 6, 20).method_46431();
        this.widgets = Lists.newArrayList((Object[])new class_339[]{this.mainWidget, this.resetButton});
    }

    public void onChange() {
        if (this.changeConsumer != null) {
            this.changeConsumer.accept(this, (AbstractDynamicEntry)((Object)this.getValue()));
        }
    }

    public final void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public boolean isEdited() {
        return super.isEdited() || this.original != this.getValue();
    }

    public void setEnabledState(boolean active) {
        if (!this.locked) {
            this.enabled = active;
            this.mainWidget.field_22763 = active;
            this.resetButton.field_22763 = active;
            this.onChange();
        }
    }

    public BiConsumer<AbstractDynamicEntry<T>, T> getChangeConsumer() {
        return this.changeConsumer;
    }

    public T getValue() {
        return this.value.get();
    }

    public void setValue(T value) {
        if (!this.locked && this.enabled) {
            this.value.set(value);
        }
    }

    public T getOriginal() {
        return this.original;
    }

    public final Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public final void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        this.resetButton.field_22763 = this.isEnabled() && this.isEditable() && this.getDefaultValue().isPresent() && !this.getDefaultValue().get().equals(this.getValue());
        this.resetButton.method_46419(y);
        this.mainWidget.field_22763 = this.isEnabled() && this.isEditable();
        this.mainWidget.method_46419(y);
        this.onRender(matrices, y, x, entryWidth, entryHeight);
        this.resetButton.method_25394(matrices, mouseX, mouseY, delta);
        this.mainWidget.method_25394(matrices, mouseX, mouseY, delta);
    }

    abstract class_339 createMainWidget();

    abstract void onRender(class_4587 var1, int var2, int var3, int var4, int var5);

    public class_2561 getDisplayedFieldName() {
        boolean notEnabled;
        class_5250 text = this.getFieldName().method_27661();
        boolean hasError = this.getConfigError().isPresent();
        boolean isEdited = this.isEdited();
        boolean bl = notEnabled = !this.isEnabled();
        if (hasError) {
            text = text.method_27692(class_124.field_1061);
        }
        if (isEdited) {
            text = text.method_27692(class_124.field_1056);
        }
        if (!hasError && !isEdited || notEnabled) {
            text = text.method_27692(class_124.field_1080);
        }
        if (notEnabled) {
            text = text.method_27692(class_124.field_1055);
        }
        return text;
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public List<? extends class_6379> narratables() {
        return this.widgets;
    }
}

