/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.util;

import io.github.bumblesoftware.fastload.api.events.AbstractEvent;
import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.client.FLClientHandler;
import io.github.bumblesoftware.fastload.config.FLMath;

public final class TickTimer {
    private int remainingTime = 0;

    public TickTimer(AbstractEvent<FLClientEvents.RecordTypes.TickEventContext> abstractUnsafeEvent) {
        abstractUnsafeEvent.registerThreadUnsafe(1L, (eventContext, abstractParent, closer, eventArgs) -> {
            if (this.remainingTime > 0) {
                --this.remainingTime;
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log(String.valueOf(this.remainingTime));
                }
            }
            return null;
        });
    }

    public boolean isReady() {
        return this.remainingTime > 0;
    }

    public void setTime(int remainingTime) {
        if (remainingTime < 0) {
            throw new RuntimeException("FLTimer was called with a negative number!");
        }
        this.remainingTime = remainingTime;
    }

    public void setTime(int remainingTime, boolean inSeconds) {
        if (inSeconds) {
            remainingTime *= 20;
        }
        this.setTime(remainingTime);
    }

    public int getTime() {
        return this.remainingTime;
    }
}

