/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.util;

import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class MinecraftVersionUtil {
    public static boolean matchesAny(String ... versions) {
        for (String version : versions) {
            if (!MinecraftVersionUtil.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesWhen(String operator, String version) {
        int currentVersionNum = Integer.parseInt(MinecraftVersionUtil.getVersion().replaceAll("\\.", ""));
        int versionNum = Integer.parseInt(version.replaceAll("\\.", ""));
        if (FLMath.isDebugEnabled().booleanValue()) {
            Fastload.LOGGER.info(currentVersionNum + operator + versionNum);
        }
        if (operator != null) {
            switch (operator) {
                case ">": {
                    if (currentVersionNum <= versionNum) break;
                    return true;
                }
                case "<": {
                    if (currentVersionNum >= versionNum) break;
                    return true;
                }
                case "<=": 
                case "=<": {
                    if (currentVersionNum > versionNum) break;
                    return true;
                }
                case ">=": 
                case "=>": {
                    if (currentVersionNum < versionNum) break;
                    return true;
                }
                default: {
                    throw new NumberFormatException("Unsupported operator: " + operator);
                }
            }
        }
        return false;
    }

    public static boolean matchesWhen(String[] operators, String[] versions) {
        if (operators.length != versions.length) {
            throw new NumberFormatException("Quantity of operators and versions are unequal. Cannot compare");
        }
        for (int i = 0; i < operators.length; ++i) {
            if (MinecraftVersionUtil.matchesWhen(operators[i], versions[i])) continue;
            return false;
        }
        return true;
    }

    public static String getVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion().getFriendlyString();
    }
}

