/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.init;

import io.github.bumblesoftware.fastload.abstraction.client.AbstractClientCalls;
import io.github.bumblesoftware.fastload.abstraction.tool.AbstractedClientHolder;
import io.github.bumblesoftware.fastload.abstraction.tool.AbstractionEvents;
import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.client.FLClientHandler;
import io.github.bumblesoftware.fastload.config.DefaultConfig;
import io.github.bumblesoftware.fastload.config.FLConfig;
import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.BuiltinAbstractionMappings;
import io.github.bumblesoftware.fastload.init.Fastload;
import io.github.bumblesoftware.fastload.util.MinecraftVersionUtil;
import net.fabricmc.api.ClientModInitializer;

public class FastloadClient
implements ClientModInitializer {
    public static AbstractClientCalls ABSTRACTED_CLIENT;

    public void onInitializeClient() {
        BuiltinAbstractionMappings.register();
        ABSTRACTED_CLIENT = FastloadClient.getAbstractedClient();
        FLConfig.init();
        FLClientEvents.init();
        FLClientHandler.init();
        MinecraftVersionUtil.getVersion();
        Fastload.LOGGER.info("Fastload Perceived Version: " + MinecraftVersionUtil.getVersion());
        Fastload.LOGGER.info("Fastload Abstraction Supported Versions: " + ABSTRACTED_CLIENT.getCompatibleVersions());
        Fastload.LOGGER.info(FastloadClient.logKey("debug") + FLMath.isDebugEnabled().toString().toUpperCase());
        Fastload.LOGGER.info(FastloadClient.logKey("chunk_try_limit") + FLMath.getChunkTryLimit());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.LOCAL_RENDER_RADIUS_KEY) + FLMath.getLocalRenderChunkRadius());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.LOCAL_RENDER_AREA_KEY) + FLMath.getLocalRenderChunkArea());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.SERVER_RENDER_RADIUS_KEY) + FLMath.getServerRenderChunkRadius());
        Fastload.LOGGER.info(FastloadClient.logKey(DefaultConfig.SERVER_RENDER_AREA_KEY) + FLMath.getServerRenderChunkArea());
    }

    private static AbstractClientCalls getAbstractedClient() {
        AbstractedClientHolder clientHolder = new AbstractedClientHolder(null);
        AbstractionEvents.CLIENT_ABSTRACTION_EVENT.fireEvent(clientHolder);
        if (clientHolder.clientCalls != null) {
            return clientHolder.clientCalls;
        }
        throw new NullPointerException("Method abstraction for MC Client is unsupported for this version");
    }

    private static String logKey(String key) {
        return key.toUpperCase() + ": ";
    }
}

