/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.config;

import io.github.bumblesoftware.fastload.config.DefaultConfig;
import io.github.bumblesoftware.fastload.config.FLConfig;
import io.github.bumblesoftware.fastload.init.FastloadClient;
import io.github.bumblesoftware.fastload.util.Bound;

public class FLMath {
    public static double getCircleArea(int radius) {
        return Math.PI * (double)radius * (double)radius;
    }

    private static int parseRenderChunkRadius(int rawRadius, Bound bound) {
        return bound.minMax(rawRadius, integer -> Math.min(integer, FastloadClient.ABSTRACTED_CLIENT.getViewDistance()), integer -> integer);
    }

    public static int getLocalRenderChunkRadius() {
        return FLMath.parseRenderChunkRadius(FLConfig.getRawLocalRenderChunkRadius(), DefaultConfig.LOCAL_CHUNK_RADIUS_BOUND);
    }

    public static int getServerRenderChunkRadius() {
        return FLMath.parseRenderChunkRadius(FLConfig.getRawServerRenderChunkRadius(), DefaultConfig.SERVER_CHUNK_RADIUS_BOUND);
    }

    public static int getLocalRenderChunkArea() {
        return (int)FLMath.getCircleArea(FLMath.getLocalRenderChunkRadius());
    }

    public static int getServerRenderChunkArea() {
        return (int)FLMath.getCircleArea(FLMath.getServerRenderChunkRadius());
    }

    public static int getChunkTryLimit() {
        return DefaultConfig.CHUNK_TRY_LIMIT_BOUND.minMax(FLConfig.getRawChunkTryLimit());
    }

    public static Boolean isDebugEnabled() {
        return FLConfig.getRawDebug();
    }

    public static Boolean isInstantLoadEnabled() {
        return FLConfig.getRawInstantLoad();
    }

    public static Boolean isServerRenderEnabled() {
        return FLMath.getServerRenderChunkArea() > 0;
    }

    public static Boolean isLocalRenderEnabled() {
        return FLMath.getLocalRenderChunkRadius() > 0;
    }
}

