/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.client;

import io.github.bumblesoftware.fastload.client.BuildingTerrainScreen;
import io.github.bumblesoftware.fastload.client.FLClientEvents;
import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import io.github.bumblesoftware.fastload.init.FastloadClient;
import io.github.bumblesoftware.fastload.util.TickTimer;
import java.util.List;
import net.minecraft.class_434;
import net.minecraft.class_437;

public final class FLClientHandler {
    private static class_437 oldCurrentScreen = null;
    private static boolean playerReady = false;
    private static boolean playerJoined = false;
    private static Integer oldChunkLoadedCountStorage = null;
    private static Integer oldChunkBuildCountStorage = null;
    private static int preparationWarnings = 0;
    private static int buildingWarnings = 0;
    public static final TickTimer CLIENT_TIMER = new TickTimer(FLClientEvents.Events.RENDER_TICK_EVENT);

    public static void init() {
        FLClientHandler.registerEvents();
    }

    public static void log(String toLog) {
        Fastload.LOGGER.info(toLog);
    }

    private static void logRendering(int chunkLoadedCount) {
        if (FastloadClient.ABSTRACTED_CLIENT.isSingleplayer()) {
            FLClientHandler.log("Goal (Loaded Chunks): " + FLMath.getLocalRenderChunkArea());
            FLClientHandler.log("Loaded Chunks: " + chunkLoadedCount);
        } else {
            FLClientHandler.log("Goal (Loaded Chunks): " + FLMath.getServerRenderChunkArea());
            FLClientHandler.log("Loaded Chunks: " + chunkLoadedCount);
        }
    }

    private static void logBuilding(int chunkBuildCount) {
        if (FastloadClient.ABSTRACTED_CLIENT.isSingleplayer()) {
            FLClientHandler.log("Goal (Built Chunks): " + FLMath.getLocalRenderChunkArea());
            FLClientHandler.log("Chunk Build Count: " + chunkBuildCount);
        } else {
            FLClientHandler.log("Goal (Built Chunks): " + FLMath.getServerRenderChunkArea());
            FLClientHandler.log("Chunk Build Count: " + chunkBuildCount);
        }
    }

    private static void stopBuilding(int chunkLoadedCount, int chunkBuildCount) {
        if (playerJoined) {
            System.gc();
            if (FLMath.isDebugEnabled().booleanValue()) {
                FLClientHandler.logBuilding(chunkBuildCount);
                FLClientHandler.logRendering(chunkLoadedCount);
            }
            if (!FastloadClient.ABSTRACTED_CLIENT.isWindowFocused()) {
                CLIENT_TIMER.setTime(20);
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log("Delaying PauseMenu until worldRendering initiates.");
                }
            }
            playerJoined = false;
            oldChunkLoadedCountStorage = 0;
            oldChunkBuildCountStorage = 0;
            FastloadClient.ABSTRACTED_CLIENT.getCurrentScreen().method_25419();
        }
    }

    private static void registerEvents() {
        FLClientEvents.Events.CLIENT_PLAYER_INIT_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("shouldLoad = true");
            }
            playerReady = true;
            return null;
        });
        FLClientEvents.Events.PLAYER_JOIN_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("playerJoined = true");
            }
            playerJoined = true;
            return null;
        });
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (CLIENT_TIMER.isReady() && FastloadClient.ABSTRACTED_CLIENT.isGameMenuScreen(eventContext.screen()) && !FastloadClient.ABSTRACTED_CLIENT.isWindowFocused()) {
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log(Integer.toString(CLIENT_TIMER.getTime()));
                }
                eventContext.ci().cancel();
            }
            return null;
        });
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (FastloadClient.ABSTRACTED_CLIENT.isBuildingTerrainScreen(eventContext.screen()) && FLMath.isDebugEnabled().booleanValue()) {
                FLClientHandler.log("setScreen(new BuildingTerrain)");
            }
            return null;
        });
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (FastloadClient.ABSTRACTED_CLIENT.isDownloadingTerrainScreen(eventContext.screen())) {
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.log("setScreen(new DownloadingTerrainScreen)");
                }
                if (playerReady && playerJoined && FLMath.isInstantLoadEnabled().booleanValue()) {
                    eventContext.ci().cancel();
                    FastloadClient.ABSTRACTED_CLIENT.getClientInstance().method_1507(null);
                    playerReady = false;
                    playerJoined = false;
                    CLIENT_TIMER.setTime(20);
                }
            }
            return null;
        });
        FLClientEvents.Events.SET_SCREEN_EVENT.registerThreadUnsafe(1L, List.of("LevelLoadingScreen_replace_via_redirect"), (eventContext, event, closer, eventArgs) -> {
            Boolean isPreRenderEnabled = FLMath.isLocalRenderEnabled();
            if (FLMath.isDebugEnabled().booleanValue()) {
                Fastload.LOGGER.info("isLocalRenderEnabled: " + isPreRenderEnabled);
                Fastload.LOGGER.info("localRenderChunkRadius: " + FLMath.getLocalRenderChunkRadius());
                Fastload.LOGGER.info("Fastload Perceived Render Distance: " + FastloadClient.ABSTRACTED_CLIENT.getViewDistance());
            }
            if (isPreRenderEnabled.booleanValue()) {
                FastloadClient.ABSTRACTED_CLIENT.setScreen(FastloadClient.ABSTRACTED_CLIENT.newBuildingTerrainScreen(FLMath.getLocalRenderChunkArea()));
                if (FLMath.isDebugEnabled().booleanValue()) {
                    Fastload.LOGGER.info("LevelLoadingScreen -> BuildingTerrainScreen");
                    Fastload.LOGGER.info("Goal (Loaded Chunks): " + FLMath.getLocalRenderChunkArea());
                }
            } else {
                FastloadClient.ABSTRACTED_CLIENT.setScreen((class_437)new class_434());
            }
            return null;
        });
        FLClientEvents.Events.RENDER_TICK_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (FastloadClient.ABSTRACTED_CLIENT.forCurrentScreen(FastloadClient.ABSTRACTED_CLIENT::isBuildingTerrainScreen) && FastloadClient.ABSTRACTED_CLIENT.getClientWorld() != null) {
                int chunkLoadedCount = FastloadClient.ABSTRACTED_CLIENT.getLoadedChunkCount();
                int chunkBuildCount = FastloadClient.ABSTRACTED_CLIENT.getCompletedChunkCount();
                int oldPreparationWarningCache = preparationWarnings;
                int oldBuildingWarningCache = buildingWarnings;
                int loadingAreaGoal = ((BuildingTerrainScreen)FastloadClient.ABSTRACTED_CLIENT.getCurrentScreen()).loadingAreaGoal;
                if (FLMath.isDebugEnabled().booleanValue()) {
                    FLClientHandler.logRendering(chunkLoadedCount);
                    FLClientHandler.logBuilding(chunkBuildCount);
                }
                if (oldChunkLoadedCountStorage != null && oldChunkBuildCountStorage != null && chunkBuildCount > 0 && chunkLoadedCount > 0) {
                    if (oldChunkLoadedCountStorage == chunkLoadedCount) {
                        ++preparationWarnings;
                    }
                    if (oldChunkBuildCountStorage == chunkBuildCount) {
                        ++buildingWarnings;
                    }
                    if (buildingWarnings >= FLMath.getChunkTryLimit() || preparationWarnings >= FLMath.getChunkTryLimit()) {
                        buildingWarnings = 0;
                        preparationWarnings = 0;
                        FLClientHandler.log("Rendering is either taking too long or hit a roadblock. If you are in a server, this is potentially a limitation of the servers render distance and can be ignored.");
                        FLClientHandler.stopBuilding(chunkLoadedCount, chunkBuildCount);
                    }
                    int spamLimit = 2;
                    if (preparationWarnings > 0) {
                        if (oldPreparationWarningCache == preparationWarnings && preparationWarnings > 2) {
                            FLClientHandler.log("Same prepared chunk count returned " + preparationWarnings + " time(s) in a row!");
                            FLClientHandler.log("Had it be " + FLMath.getChunkTryLimit() + " time(s) in a row, rendering would've stopped");
                            if (FLMath.isDebugEnabled().booleanValue()) {
                                FLClientHandler.logRendering(chunkLoadedCount);
                            }
                        }
                        if (chunkLoadedCount > oldChunkLoadedCountStorage) {
                            preparationWarnings = 0;
                        }
                    }
                    if (buildingWarnings > 0) {
                        if (oldBuildingWarningCache == buildingWarnings && buildingWarnings > 2) {
                            FLClientHandler.log("Same built chunk count returned " + buildingWarnings + " time(s) in a row!");
                            FLClientHandler.log("Had it be " + FLMath.getChunkTryLimit() + " time(s) in a row, rendering would've stopped");
                            if (FLMath.isDebugEnabled().booleanValue()) {
                                FLClientHandler.logRendering(chunkLoadedCount);
                            }
                        }
                        if (chunkBuildCount > oldChunkBuildCountStorage) {
                            buildingWarnings = 0;
                        }
                    }
                }
                oldChunkLoadedCountStorage = chunkLoadedCount;
                oldChunkBuildCountStorage = chunkBuildCount;
                if (chunkLoadedCount >= loadingAreaGoal && chunkBuildCount >= loadingAreaGoal) {
                    FLClientHandler.stopBuilding(chunkLoadedCount, chunkBuildCount);
                    FLClientHandler.log("Successfully pre-loaded the world!");
                }
            }
            return null;
        });
        FLClientEvents.Events.RENDER_TICK_EVENT.registerThreadUnsafe(1L, (eventContext, abstractUnsafeEvent, closer, eventArgs) -> {
            if (FLMath.isDebugEnabled().booleanValue()) {
                FastloadClient.ABSTRACTED_CLIENT.forCurrentScreen(screen -> {
                    if (oldCurrentScreen != screen) {
                        oldCurrentScreen = screen;
                        Fastload.LOGGER.info("Screen changed to: " + screen);
                    }
                    return false;
                });
            }
            return null;
        });
    }
}

