/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.api.events;

import io.github.bumblesoftware.fastload.api.events.AbstractEvent;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CapableEvent<Context>
implements AbstractEvent<Context> {
    public final Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> allEvents;
    public final Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> eventsToAdd;
    public final Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> eventsToRemove;
    @Nullable
    public final SwitchHelper<Context> switchHelper;

    public CapableEvent(@Nullable SwitchHelper<Context> switchHelper) {
        this.switchHelper = switchHelper;
        this.allEvents = new Object2ObjectOpenHashMap();
        this.eventsToAdd = new Object2ObjectOpenHashMap();
        this.eventsToRemove = new Object2ObjectOpenHashMap();
        this.allEvents.put((Object)"generic", this.getNewHolder());
        this.eventsToAdd.put((Object)"generic", this.getNewHolder());
        this.eventsToRemove.put((Object)"generic", this.getNewHolder());
    }

    public CapableEvent() {
        this(null);
    }

    @Override
    public Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> getStorage() {
        return this.allEvents;
    }

    @Override
    public void removeThreadSafe(long priority, List<String> locations, AbstractEvent.EventArgs<Context> eventArgs) {
        for (String string : locations) {
            this.eventsToRemove.putIfAbsent((Object)string, this.getNewHolder());
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.eventsToRemove.get((Object)string);
            if (!holder.priorityHolder().contains(priority)) {
                holder.priorityHolder().add(priority);
            }
            if (!holder.argsHolder().containsKey(priority)) {
                ArrayList<AbstractEvent.EventArgs<Context>> list = new ArrayList<AbstractEvent.EventArgs<Context>>();
                list.add(eventArgs);
                holder.argsHolder().put(priority, list);
                continue;
            }
            if (((List)holder.argsHolder().get(priority)).contains(eventArgs)) continue;
            ((List)holder.argsHolder().get(priority)).add(eventArgs);
        }
    }

    @Override
    public void registerThreadsafe(long priority, List<String> locations, AbstractEvent.EventArgs<Context> eventArgs) {
        for (String string : locations) {
            this.eventsToAdd.putIfAbsent((Object)string, this.getNewHolder());
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.eventsToAdd.get((Object)string);
            if (!holder.priorityHolder().contains(priority)) {
                holder.priorityHolder().add(priority);
            }
            if (!holder.argsHolder().containsKey(priority)) {
                ArrayList<AbstractEvent.EventArgs<Context>> list = new ArrayList<AbstractEvent.EventArgs<Context>>();
                list.add(eventArgs);
                holder.argsHolder().put(priority, list);
                continue;
            }
            if (((List)holder.argsHolder().get(priority)).contains(eventArgs)) continue;
            ((List)holder.argsHolder().get(priority)).add(eventArgs);
        }
    }

    @Override
    public void registerThreadUnsafe(long priority, List<String> locations, AbstractEvent.EventArgs<Context> eventArgs) {
        for (String string : locations) {
            this.allEvents.putIfAbsent((Object)string, this.getNewHolder());
            AbstractEvent.EventHolder holder = (AbstractEvent.EventHolder)this.allEvents.get((Object)string);
            ArrayList<Long> priHol = holder.priorityHolder();
            Long2ObjectMap argHol = holder.argsHolder();
            if (!priHol.contains(priority)) {
                priHol.add(priority);
            }
            if (!argHol.containsKey(priority)) {
                ArrayList<AbstractEvent.EventArgs<Context>> list = new ArrayList<AbstractEvent.EventArgs<Context>>();
                list.add(eventArgs);
                argHol.put(priority, list);
                continue;
            }
            if (((List)argHol.get(priority)).contains(eventArgs)) continue;
            ((List)argHol.get(priority)).add(eventArgs);
        }
    }

    @Override
    public Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Context>> getMultipleArgsHolders(String identifier) {
        if (this.switchHelper == null) {
            throw new UnsupportedOperationException();
        }
        return this.switchHelper.switchWith(identifier);
    }

    private void iterate(AbstractEvent.EventHolder<Context> holder, ArgsIterator<Context> argsIterator) {
        if (holder != null) {
            for (long priority : holder.priorityHolder()) {
                for (AbstractEvent.EventArgs arg : (List)holder.argsHolder().get(priority)) {
                    if (arg == null) continue;
                    argsIterator.onElement(priority, arg);
                }
            }
        }
    }

    @Override
    public void fireEvent(List<String> locations, Context eventContext) {
        for (String string : locations) {
            AbstractEvent.EventHolder add = (AbstractEvent.EventHolder)this.eventsToAdd.get((Object)string);
            AbstractEvent.EventHolder all = (AbstractEvent.EventHolder)this.allEvents.get((Object)string);
            AbstractEvent.EventHolder remove = (AbstractEvent.EventHolder)this.eventsToRemove.remove((Object)string);
            ArrayList<Long> emptyPriorities = new ArrayList<Long>();
            this.iterate(add, this::registerThreadUnsafe);
            all.priorityHolder().sort(Comparator.reverseOrder());
            this.iterate(all, (priority, arg) -> arg.onEvent(eventContext, this, 0, arg));
            this.iterate(remove, this::removeThreadUnsafe);
            for (long priority2 : all.priorityHolder()) {
                if (!((List)all.argsHolder().get(priority2)).isEmpty()) continue;
                all.argsHolder().remove(priority2);
                emptyPriorities.add(priority2);
            }
            for (long priority2 : emptyPriorities) {
                all.priorityHolder().remove(priority2);
            }
            emptyPriorities.clear();
            if (add != null) {
                add.priorityHolder().clear();
                add.argsHolder().clear();
            }
            if (remove == null) continue;
            remove.priorityHolder().clear();
            remove.argsHolder().clear();
        }
    }

    private static interface SwitchHelper<Ctx> {
        public Object2ObjectOpenHashMap<String, AbstractEvent.EventHolder<Ctx>> switchWith(String var1);
    }

    private static interface ArgsIterator<Ctx> {
        public void onElement(long var1, AbstractEvent.EventArgs<Ctx> var3);
    }
}

