/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.panel.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.api.registry.BetterStatsRegistry;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel;
import io.github.thecsdev.betterstats.client.gui.panel.stats.BSStatPanel;
import io.github.thecsdev.betterstats.client.gui.screen.BetterStatsScreen;
import io.github.thecsdev.betterstats.client.gui_hud.screen.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui_hud.widget.BSHudStatWidget_Item;
import io.github.thecsdev.betterstats.util.ItemStatEnum;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectEnumWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3469;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class BSStatPanel_Items
extends BSStatPanel {
    public BSStatPanel_Items(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public BSStatPanel_Items(TPanelElement parentToFill) {
        super(parentToFill);
    }

    @Override
    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return stat -> stat instanceof StatUtils.StatUtilsItemStat;
    }

    @Override
    public TSelectWidget createFilterSortByWidget(BetterStatsScreen bss, int x, int y, int width, int height) {
        TSelectEnumWidget sw = new TSelectEnumWidget(x, y, width, height, BSStatPanelItems_SortBy.class);
        sw.setSelected((Enum)bss.cache.getAs("BSStatPanelItems_SortBy", BSStatPanelItems_SortBy.class, (Object)BSStatPanelItems_SortBy.Default), false);
        sw.setEnumValueToLabel(newVal -> ((BSStatPanelItems_SortBy)((Object)newVal)).asText());
        sw.setOnSelectionChange(newVal -> {
            bss.cache.set("BSStatPanelItems_SortBy", newVal);
            bss.getStatPanel().init_stats();
        });
        return sw;
    }

    @Override
    public void init(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        switch (this.getFilterGroupBy()) {
            case Mod: {
                this.initByModGroups(bss, statHandler, statFilter);
                break;
            }
            case None: {
                this.initByNoGroups(bss, statHandler, statFilter);
                break;
            }
            default: {
                this.initByItemGroups(bss, statHandler, statFilter);
            }
        }
    }

    protected void initByNoGroups(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<String, ArrayList<StatUtils.StatUtilsItemStat>> itemStats = StatUtils.getItemStatsByMods(statHandler, statFilter.and(this.getStatPredicate()));
        ArrayList allItems = Lists.newArrayList();
        for (String iGroup : itemStats.keySet()) {
            allItems.addAll((Collection)itemStats.get(iGroup));
        }
        if (itemStats.size() > 0) {
            this.init_groupLabel((class_2561)TextUtils.literal((String)"*"));
            this.init_itemStats(bss, allItems);
            this.init_totalStats(itemStats.values());
        } else {
            this.init_noResults();
        }
    }

    protected void initByItemGroups(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<class_1761, ArrayList<StatUtils.StatUtilsItemStat>> itemStats = StatUtils.getItemStats(statHandler, statFilter.and(this.getStatPredicate()));
        for (class_1761 iGroup : itemStats.keySet()) {
            class_2561 gLabel = iGroup != null ? iGroup.method_7737() : null;
            this.init_groupLabel(gLabel);
            this.init_itemStats(bss, itemStats.get(iGroup));
        }
        if (itemStats.size() == 0) {
            this.init_noResults();
        } else {
            this.init_totalStats(itemStats.values());
        }
    }

    protected void initByModGroups(BetterStatsScreen bss, class_3469 statHandler, Predicate<StatUtils.StatUtilsStat> statFilter) {
        LinkedHashMap<String, ArrayList<StatUtils.StatUtilsItemStat>> itemStats = StatUtils.getItemStatsByMods(statHandler, statFilter.and(this.getStatPredicate()));
        for (String iGroup : itemStats.keySet()) {
            this.init_groupLabel((class_2561)TextUtils.literal((String)StatUtils.getModName(iGroup)));
            this.init_itemStats(bss, itemStats.get(iGroup));
        }
        if (itemStats.size() == 0) {
            this.init_noResults();
        } else {
            this.init_totalStats(itemStats.values());
        }
    }

    protected void init_itemStats(BetterStatsScreen bss, ArrayList<StatUtils.StatUtilsItemStat> itemStats) {
        switch ((BSStatPanelItems_SortBy)((Object)bss.cache.getAs("BSStatPanelItems_SortBy", BSStatPanelItems_SortBy.class, (Object)BSStatPanelItems_SortBy.Default))) {
            case Mined: {
                Collections.sort(itemStats, (o1, o2) -> Integer.compare(o2.sMined, o1.sMined));
                break;
            }
            case Crafted: {
                Collections.sort(itemStats, (o1, o2) -> Integer.compare(o2.sCrafted, o1.sCrafted));
                break;
            }
            case PickedUp: {
                Collections.sort(itemStats, (o1, o2) -> Integer.compare(o2.sPickedUp, o1.sPickedUp));
                break;
            }
            case Dropped: {
                Collections.sort(itemStats, (o1, o2) -> Integer.compare(o2.sDropped, o1.sDropped));
                break;
            }
            case Used: {
                Collections.sort(itemStats, (o1, o2) -> Integer.compare(o2.sUsed, o1.sUsed));
                break;
            }
            case Broken: {
                Collections.sort(itemStats, (o1, o2) -> Integer.compare(o2.sBroken, o1.sBroken));
                break;
            }
        }
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        for (StatUtils.StatUtilsItemStat stat : itemStats) {
            this.addTChild(this.createStatWidget(stat, nextX, nextY), false);
            if ((nextX += 22) + 21 <= this.getTpeEndX() - this.getScrollPadding()) continue;
            nextX = this.getTpeX() + this.getScrollPadding();
            nextY += 22;
        }
    }

    protected void init_totalStats(Collection<ArrayList<StatUtils.StatUtilsItemStat>> itemStats) {
        int tMined = 0;
        int tCrafted = 0;
        int tUsed = 0;
        int tBroken = 0;
        int tPickedUp = 0;
        int tDropped = 0;
        for (ArrayList<StatUtils.StatUtilsItemStat> group : itemStats) {
            for (StatUtils.StatUtilsItemStat groupMob : group) {
                if (groupMob == null || groupMob.isEmpty()) continue;
                tMined += groupMob.sMined;
                tCrafted += groupMob.sCrafted;
                tUsed += groupMob.sUsed;
                tBroken += groupMob.sBroken;
                tPickedUp += groupMob.sPickedUp;
                tDropped += groupMob.sDropped;
            }
        }
        StringBuilder glSb = new StringBuilder();
        glSb.append(new char[]{'\u2190', ' ', '\u2022', ' ', '\u2192'});
        TLabelElement groupLabel = this.init_groupLabel((class_2561)TextUtils.literal((String)glSb.toString()));
        groupLabel.setHorizontalAlignment(HorizontalAlignment.CENTER);
        int nextX = this.getTpeX() + this.getScrollPadding();
        int nextY = this.getTpeY() + this.getScrollPadding();
        TElement lastChild = this.getLastTChild(false);
        if (lastChild != null) {
            nextY = lastChild.getTpeEndY() + 2;
        }
        BSPanel panel = new BSPanel(nextX, nextY, this.getTpeWidth() - this.getScrollPadding() * 2, 60);
        panel.setScrollPadding(0);
        this.addTChild((TElement)panel, false);
        int leftX = 5;
        int leftW = panel.getTpeWidth() / 2 - 10;
        int rightX = panel.getTpeWidth() / 2 + 5;
        int rightW = panel.getTpeWidth() / 2 - 10;
        TLabelElement lbl_tMined_a = new TLabelElement(leftX, 0, leftW, 20, ItemStatEnum.MINED.getIText());
        TLabelElement lbl_tMined_b = new TLabelElement(leftX, 0, leftW, 20, (class_2561)TextUtils.literal((String)Integer.toString(tMined)));
        lbl_tMined_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tMined_a, true);
        panel.addTChild((TElement)lbl_tMined_b, true);
        TLabelElement lbl_tCrafted_a = new TLabelElement(rightX, 0, rightW, 20, ItemStatEnum.CRAFTED.getIText());
        TLabelElement lbl_tCrafted_b = new TLabelElement(rightX, 0, rightW, 20, (class_2561)TextUtils.literal((String)Integer.toString(tCrafted)));
        lbl_tCrafted_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tCrafted_a, true);
        panel.addTChild((TElement)lbl_tCrafted_b, true);
        TLabelElement lbl_tUsed_a = new TLabelElement(leftX, 20, leftW, 20, ItemStatEnum.USED.getIText());
        TLabelElement lbl_tUsed_b = new TLabelElement(leftX, 20, leftW, 20, (class_2561)TextUtils.literal((String)Integer.toString(tUsed)));
        lbl_tUsed_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tUsed_a, true);
        panel.addTChild((TElement)lbl_tUsed_b, true);
        TLabelElement lbl_tBroken_a = new TLabelElement(rightX, 20, rightW, 20, ItemStatEnum.BROKEN.getIText());
        TLabelElement lbl_tBroken_b = new TLabelElement(rightX, 20, rightW, 20, (class_2561)TextUtils.literal((String)Integer.toString(tBroken)));
        lbl_tBroken_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tBroken_a, true);
        panel.addTChild((TElement)lbl_tBroken_b, true);
        TLabelElement lbl_tPickedUp_a = new TLabelElement(leftX, 40, leftW, 20, ItemStatEnum.PICKED_UP.getIText());
        TLabelElement lbl_tPickedUp_b = new TLabelElement(leftX, 40, leftW, 20, (class_2561)TextUtils.literal((String)Integer.toString(tPickedUp)));
        lbl_tPickedUp_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tPickedUp_a, true);
        panel.addTChild((TElement)lbl_tPickedUp_b, true);
        TLabelElement lbl_tDropped_a = new TLabelElement(rightX, 40, rightW, 20, ItemStatEnum.DROPPED.getIText());
        TLabelElement lbl_tDropped_b = new TLabelElement(rightX, 40, rightW, 20, (class_2561)TextUtils.literal((String)Integer.toString(tDropped)));
        lbl_tDropped_b.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        panel.addTChild((TElement)lbl_tDropped_a, true);
        panel.addTChild((TElement)lbl_tDropped_b, true);
    }

    protected BSStatWidget_Item createStatWidget(StatUtils.StatUtilsItemStat stat, int x, int y) {
        return new BSStatWidget_Item(stat, x, y);
    }

    public static enum BSStatPanelItems_SortBy {
        Default(TextUtils.literal((String)"-")),
        Mined(TextUtils.translatable((String)"stat_type.minecraft.mined", (Object[])new Object[0])),
        Crafted(TextUtils.translatable((String)"stat_type.minecraft.crafted", (Object[])new Object[0])),
        PickedUp(TextUtils.translatable((String)"stat_type.minecraft.picked_up", (Object[])new Object[0])),
        Dropped(TextUtils.translatable((String)"stat_type.minecraft.dropped", (Object[])new Object[0])),
        Used(TextUtils.translatable((String)"stat_type.minecraft.used", (Object[])new Object[0])),
        Broken(TextUtils.translatable((String)"stat_type.minecraft.broken", (Object[])new Object[0]));

        private final class_5250 text;

        private BSStatPanelItems_SortBy(class_5250 text) {
            this.text = text;
        }

        public class_5250 asText() {
            return this.text;
        }
    }

    protected class BSStatWidget_Item
    extends BSStatPanel.BSStatWidget {
        public static final int SIZE = 21;
        public final StatUtils.StatUtilsItemStat stat;
        public final class_1799 stack;
        public static final boolean SHOW_ITEM_NAMES = true;

        public BSStatWidget_Item(StatUtils.StatUtilsItemStat stat, int x, int y) {
            super(x, y, 21, 21);
            this.stat = stat;
            this.stack = stat.item.method_7854();
            this.updateTooltip();
        }

        @Override
        public void updateTooltip() {
            String sMined = TextUtils.translatable((String)"stat_type.minecraft.mined", (Object[])new Object[0]).getString();
            String sCrafted = TextUtils.translatable((String)"stat_type.minecraft.crafted", (Object[])new Object[0]).getString();
            String sPicked = TextUtils.translatable((String)"stat_type.minecraft.picked_up", (Object[])new Object[0]).getString();
            String sDroppp = TextUtils.translatable((String)"stat_type.minecraft.dropped", (Object[])new Object[0]).getString();
            String sUsed = TextUtils.translatable((String)"stat_type.minecraft.used", (Object[])new Object[0]).getString();
            String sBroken = TextUtils.translatable((String)"stat_type.minecraft.broken", (Object[])new Object[0]).getString();
            class_5250 tooltip = TextUtils.literal((String)(TextUtils.translatable((String)this.stat.item.method_7876(), (Object[])new Object[0]).getString() + "\n\n" + sMined + " - " + this.stat.sMined + "\n" + sCrafted + " - " + this.stat.sCrafted + "\n" + sPicked + " - " + this.stat.sPickedUp + "\n" + sDroppp + " - " + this.stat.sDropped + "\n" + sUsed + " - " + this.stat.sUsed + "\n" + sBroken + " - " + this.stat.sBroken));
            this.setTooltip((class_2561)tooltip);
        }

        @Override
        public boolean mousePressed(int mouseX, int mouseY, int button) {
            String url;
            if (!(button != 0 && button != 1 || this.stack == null || class_437.method_25442())) {
                try {
                    boolean opened;
                    ViewSearchBuilder builder = ViewSearchBuilder.builder();
                    EntryStack entryStack = EntryStacks.of((class_1799)this.stack);
                    if (button == 0) {
                        builder.addRecipesFor(entryStack);
                    }
                    if (button == 1) {
                        builder.addUsagesFor(entryStack);
                    }
                    if (opened = ClientHelper.getInstance().openView(builder)) {
                        return false;
                    }
                }
                catch (NoClassDefFoundError builder) {}
            } else if (button == 2 && (url = BetterStatsRegistry.getItemWikiURL(class_7923.field_41178.method_10221((Object)this.stat.item))) != null) {
                GuiUtils.showUrlPrompt((String)url, (boolean)false);
                return false;
            }
            return super.mousePressed(mouseX, mouseY, button);
        }

        @Override
        public void render(class_4587 matrices, int mouseX, int mouseY, float deltaTime) {
            super.render(matrices, mouseX, mouseY, deltaTime);
            this.getItemRenderer().method_4010(matrices, this.stack, this.getTpeX() + 3, this.getTpeY() + 3);
        }

        protected void onContextMenu(TContextMenuPanel contextMenu) {
            super.onContextMenu(contextMenu);
            contextMenu.addButton((class_2561)TextUtils.translatable((String)"betterstats.gui.ctx_menu.pin_to_hud", (Object[])new Object[0]), btn -> {
                BetterStatsHudScreen bshs = BetterStatsHudScreen.getOrCreateInstance((class_437)this.screen);
                this.getClient().method_1507((class_437)bshs);
                bshs.addHudStatWidget(new BSHudStatWidget_Item(0, 0, this.stat.statHandler, this.stat.item));
            });
            contextMenu.addButton((class_2561)TextUtils.translatable((String)"betterstats.gui.ctx_menu.close", (Object[])new Object[0]), btn -> {});
        }
    }
}

