/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.server.BetterStatsServer;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BetterStats {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)BetterStats.getModID());
    private static final String ModID = "betterstats";
    private static BetterStats Instance;
    public final ModContainer modInfo;

    public BetterStats() {
        if (BetterStats.isModInitialized()) {
            throw new IllegalStateException(BetterStats.getModID() + " has already been initialized.");
        }
        if (!BetterStats.isInstanceValid(this)) {
            throw new UnsupportedOperationException("Invalid " + BetterStats.getModID() + " type: " + this.getClass().getName());
        }
        Instance = this;
        this.modInfo = (ModContainer)FabricLoader.getInstance().getModContainer(BetterStats.getModID()).get();
        LOGGER.info("Initializing '" + BetterStats.getModName() + "' as '" + this.getClass().getSimpleName() + "'.");
    }

    public ModContainer getModInfo() {
        return this.modInfo;
    }

    public static BetterStats getInstance() {
        return Instance;
    }

    public static String getModName() {
        return BetterStats.getInstance().getModInfo().getMetadata().getName();
    }

    public static String getModID() {
        return ModID;
    }

    public static boolean isModInitialized() {
        return BetterStats.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(BetterStats instance) {
        return BetterStats.isServer(instance) || BetterStats.isClient(instance);
    }

    public static boolean isServer() {
        return BetterStats.isServer(Instance);
    }

    public static boolean isClient() {
        return BetterStats.isClient(Instance);
    }

    private static boolean isServer(BetterStats arg0) {
        return arg0 instanceof BetterStatsServer;
    }

    private static boolean isClient(BetterStats arg0) {
        return arg0 instanceof BetterStatsClient;
    }

    @Nullable
    public static class_1761 getItemGroup(class_1792 item) {
        if (item == null) {
            return null;
        }
        for (class_1761 group : class_7706.method_47341()) {
            List<class_1792> items;
            if (group == class_7706.field_40200 || !(items = group.method_47313().stream().map(stack -> stack.method_7909()).toList()).contains(item)) continue;
            return group;
        }
        return null;
    }
}

